% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otherplots.R
\name{barplotLand}
\alias{barplotLand}
\title{Area of LUC categories at time points}
\usage{
barplotLand(
  dataset,
  legendtable,
  title = NULL,
  caption = "LUC Categories",
  xlab = "Year",
  ylab = "Area (km2 or pixel)",
  area_km2 = TRUE,
  ...
)
}
\arguments{
\item{dataset}{A table of the multi step transitions (\code{lulc_Multistep})
generated by \code{\link{contingencyTable}}.}

\item{legendtable}{A table containing the LUC legend items and their respective
color (\code{tb_legend}).}

\item{title}{character. The title of the plot.}

\item{caption}{character. The caption of the plot.}

\item{xlab}{character. Label for the x axis.}

\item{ylab}{character. Label for the y axis.}

\item{area_km2}{logical. If TRUE the change is computed in km2, if FALSE in
pixel counts.}

\item{\dots}{additional themes parameters, see \code{\link[ggplot2]{theme}}.}
}
\value{
a barplot
}
\description{
A grouped barplot representing the areas of LUC categories at each time point
of the analysed period.
}
\examples{

# editing the category names

SL_2002_2014$tb_legend$categoryName <- factor(c("Ap", "FF", "SA", "SG", "aa", "SF",
                                             "Agua", "Iu", "Ac", "R", "Im"),
                                  levels = c("FF", "SF", "SA", "SG", "aa", "Ap",
                                             "Ac", "Im", "Iu", "Agua", "R"))

SL_2002_2014$tb_legend$color <- c("#FFE4B5", "#228B22", "#00FF00", "#CAFF70",
                                  "#EE6363", "#00CD00", "#436EEE", "#FFAEB9",
                                  "#FFA54F", "#68228B", "#636363")
# the plot
barplotLand(dataset = SL_2002_2014$lulc_Multistep,
            legendtable = SL_2002_2014$tb_legend,
            area_km2 = TRUE)


}
\seealso{
\code{ggplot2::\link[ggplot2]{theme}}
}
