% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOMLTask.R
\name{getOMLTask}
\alias{getOMLTask}
\title{Get an OpenML task.}
\usage{
getOMLTask(task.id, cache.only = FALSE, verbosity = NULL)
}
\arguments{
\item{task.id}{[\code{integer(1)}]\cr
Task ID.}

\item{cache.only}{[\code{logical(1)}]\cr
Only try to retrieve the object from cache.
Will result in error if the object is not found.
Default is \code{FALSE}.}

\item{verbosity}{[\code{integer(1)}]\cr
Print verbose output on console? Possible values are:\cr
\code{0}: normal output,\cr
\code{1}: info output,\cr
\code{2}: debug output.\cr
Default is set via \code{\link{setOMLConfig}}.}
}
\value{
[\code{\link{OMLTask}}].
}
\description{
Given a task ID, the corresponding \code{\link{OMLTask}} will be downloaded
(if not in cache) and returned.
}
\examples{
# # Download task and access relevant information to start running experiments
# \dontrun{
#   task = getOMLTask(1)
#   task
#   task$task.type
#   task$input$data.set
#   head(task$input$data.set$data)
# }
}
\seealso{
Other downloading functions: \code{\link{getOMLDataSetQualities}},
  \code{\link{getOMLDataSet}}, \code{\link{getOMLFlow}},
  \code{\link{getOMLRun}}, \code{\link{getOMLStudy}}

Other task-related functions: \code{\link{convertOMLTaskToMlr}},
  \code{\link{deleteOMLObject}},
  \code{\link{listOMLTaskTypes}},
  \code{\link{listOMLTasks}}, \code{\link{makeOMLTask}},
  \code{\link{tagOMLObject}}
}
\concept{downloading functions}
\concept{task-related functions}
