% Generated by roxygen2 (4.0.2): do not edit by hand
\name{mxExpectationBA81}
\alias{MxExpectationBA81-class}
\alias{mxExpectationBA81}
\alias{print,MxExpectationBA81-method}
\alias{show,MxExpectationBA81-method}
\title{Create a Bock & Aitkin (1981) expectation}
\usage{
mxExpectationBA81(ItemSpec, item = "item", ..., qpoints = 49L, qwidth = 6,
  mean = "mean", cov = "cov", verbose = 0L, weightColumn = NA_integer_,
  EstepItem = NULL, debugInternal = FALSE)
}
\arguments{
\item{ItemSpec}{a single item model (to replicate) or a list of
item models in the same order as the column of \code{ItemParam}}

\item{item}{the name of the mxMatrix holding item parameters
with one column for each item model with parameters starting at
row 1 and extra rows filled with NA}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{qpoints}{number of points to use for equal interval quadrature integration (default 49L)}

\item{qwidth}{the width of the quadrature as a positive Z score (default 6.0)}

\item{mean}{the name of the mxMatrix holding the mean vector}

\item{cov}{the name of the mxMatrix holding the covariance matrix}

\item{verbose}{the level of runtime diagnostics (default 0L)}

\item{weightColumn}{the name of the column in the data containing the row weights (default NA)}

\item{EstepItem}{a simple matrix of item parameters for the
E-step. This option is mainly of use for debugging derivatives.}

\item{debugInternal}{when enabled, some of the internal tables are
returned in $debug. This is mainly of use to developers.}
}
\description{
When a two-tier covariance matrix is recognized, this expectation
automatically enables analytic dimension reduction (Cai, 2010).
}
\details{
The standard Normal distribution of the quadrature acts like a
prior distribution for difficulty. It is not necessary to impose
any additional Bayesian prior on difficulty estimates (Baker &
Kim, 2004, p. 196).
}
\references{
Bock, R. D., & Aitkin, M. (1981). Marginal maximum likelihood estimation of item
parameters: Application of an EM algorithm. Psychometrika, 46, 443-459.

Cai, L. (2010). A two-tier full-information item factor analysis
model with applications. Psychometrika, 75, 581-612.

Seong, T. J. (1990). Sensitivity of marginal maximum likelihood
estimation of item and ability parameters to the characteristics
of the prior ability distributions. Applied Psychological
Measurement, 14(3), 299-311.
}
\seealso{
\href{http://cran.r-project.org/web/packages/rpf/index.html}{RPF}
}

