% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openrepgrid.r
\docType{package}
\name{OpenRepGrid}
\alias{OpenRepGrid}
\alias{OpenRepGrid-package}
\title{\pkg{OpenRepGrid}: an R package for the analysis of repertory grids.}
\description{
The \pkg{OpenRepGrid} package provides tools for the analysis of repertory grid data.
The repertory grid is a method devised by George Alexander Kelly
in his seminal work "The Psychology of Personal Constructs" published in 1955.
The repertory grid has been used in and outside the context of Personal Construct 
Psychology (PCP) in a broad range of fields. For an introduction into the 
technique see e.g. Fransella, Bell and Bannister (2003).
}
\note{
To get started with \pkg{OpenRepGrid} visit the project's home under \url{www.openrepgrid.org}. 
           On this site you will find tutorials, explanation about the theory, methods of analysis and 
           the according R code.

           To see the preferable citation of the \pkg{OpenRepGrid} package, type 
           \code{citation("OpenRepGrid")} into the R console.

           Disclaimer: Note that the package is distributed under the 
           \href{http://www.gnu.org/licenses/gpl-2.0.html}{GPL 2 license}.
           It is work in progress and is continuously being improved by hopefully 
           numerous contributors. It may contain bugs and errors.
           There is no warranty whatsoever for the program.
}
\references{
Fransella, F., Bell, R. C., & Bannister, D. (2003). \emph{A Manual for Repertory 
                 Grid Technique (2. Ed.)}. Chichester: John Wiley & Sons.

             Kelly, G. A. (1955). \emph{The psychology of personal constructs. Vol. I, II.} 
                 New York: Norton, (2nd printing: 1991, Routledge, London, New York).
}
\author{
\pkg{OpenRepGrid} was initiated by Mark Heckmann. 
           Current contributors are: Mark Heckmann, Alejandro García.
           Researchers interested in developing the package are invited to join.

           The \pkg{OpenRepGrid} package development is hosted on github (\url{http://github.com/markheckmann/OpenRepGrid}).
           The github site provides information and allows to file bug reports or feature requests.
           Bug reports can also be emailed to the package maintainer or issued on 
           \url{http://www.openrepgrid.org} under section \emph{Suggestions/Issues}.
           The package maintainer is Mark Heckmann  <heckmann(at)uni-bremen.de>.
}
\keyword{package}
\keyword{repgrid}
