% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repgrid-plots.r
\name{biplot2d}
\alias{biplot2d}
\title{Draw a two-dimensional biplot.}
\usage{
biplot2d(
  x,
  dim = c(1, 2),
  map.dim = 3,
  center = 1,
  normalize = 0,
  g = 0,
  h = 1 - g,
  col.active = NA,
  col.passive = NA,
  e.point.col = "black",
  e.point.cex = 0.9,
  e.label.col = "black",
  e.label.cex = 0.7,
  e.color.map = c(0.4, 1),
  c.point.col = "black",
  c.point.cex = 0,
  c.label.col = "black",
  c.label.cex = 0.7,
  c.color.map = c(0.4, 1),
  c.points.devangle = 91,
  c.labels.devangle = 91,
  c.points.show = TRUE,
  c.labels.show = TRUE,
  e.points.show = TRUE,
  e.labels.show = TRUE,
  inner.positioning = TRUE,
  outer.positioning = TRUE,
  c.labels.inside = FALSE,
  c.lines = TRUE,
  col.c.lines = grey(0.9),
  flipaxes = c(FALSE, FALSE),
  strokes.x = 0.1,
  strokes.y = 0.1,
  offsetting = TRUE,
  offset.labels = 0,
  offset.e = 1,
  axis.ext = 0.1,
  mai = c(0.2, 1.5, 0.2, 1.5),
  rect.margins = c(0.01, 0.01),
  srt = 45,
  cex.pos = 0.7,
  xpd = TRUE,
  unity = FALSE,
  unity3d = FALSE,
  scale.e = 0.9,
  zoom = 1,
  var.show = TRUE,
  var.cex = 0.7,
  var.col = grey(0.1),
  ...
)
}
\arguments{
\item{x}{\code{repgrid} object.}

\item{dim}{Dimensions (i.e. principal components) to be used for biplot
(default is \code{c(1,2)}).}

\item{map.dim}{Third dimension (depth) used to map aesthetic attributes to
(default is \code{3}).}

\item{center}{Numeric. The type of centering to be performed.
0= no centering, 1= row mean centering (construct),
2= column mean centering (elements), 3= double-centering (construct and element means),
4= midpoint centering of rows (constructs).
The default is \code{1} (row centering).}

\item{normalize}{A numeric value indicating along what direction (rows, columns)
to normalize by standard deviations. \verb{0 = none, 1= rows, 2 = columns}
(default is \code{0}).}

\item{g}{Power of the singular value matrix assigned to the left singular
vectors, i.e. the constructs.}

\item{h}{Power of the singular value matrix assigned to the right singular
vectors, i.e. the elements.}

\item{col.active}{Columns (elements) that are no supplementary points, i.e. they are used
in the SVD to find principal components. default is to use all elements.}

\item{col.passive}{Columns (elements) that are supplementary points, i.e. they are NOT used
in the SVD but projected into the component space afterwards. They do not
determine the solution. Default is \code{NA}, i.e. no elements are set
supplementary.}

\item{e.point.col}{Color of the element symbols. The default is \code{"black"}.
Two values can be entered that will create a color ramp. The values of
\code{map.dim} are mapped onto the ramp.
If only one color color value is supplied (e.g. \code{"black"})
no mapping occurs and all elements will have the same color
irrespective of their value on the \code{map.dim} dimension.}

\item{e.point.cex}{Size of the element symbols. The default is \code{.9}.
Two values can be entered that will create a size ramp. The values of
\code{map.dim} are mapped onto the ramp.
If only one color size value is supplied (e.g. \code{.8})
no mapping occurs and all elements will have the same size
irrespective of their value on the \code{map.dim} dimension.}

\item{e.label.col}{Color of the element label. The default is \code{"black"}.
Two values can be entered that will create a color ramp. The values of
\code{map.dim} are mapped onto the ramp.
If only one color color value is supplied (e.g. \code{"black"})
no mapping occurs and all labels will have the same color
irrespective of their value on the \code{map.dim} dimension.}

\item{e.label.cex}{Size of the element labels. The default is \code{.7}.
Two values can be entered that will create a size ramp. The values of
\code{map.dim} are mapped onto the ramp.
If only one color size value is supplied (e.g. \code{.7})
no mapping occurs and all labels will have the same size
irrespective of their value on the \code{map.dim} dimension.}

\item{e.color.map}{Value range to determine what range of the color ramp defined in
\code{e.color} will be used for mapping the colors.
Default is \code{c(.4, ,1)}. Usually not important for the user.}

\item{c.point.col}{Color of the construct symbols. The default is \code{"black"}.
Two values can be entered that will create a color ramp. The values of
\code{map.dim} are mapped onto the ramp.
If only one color color value is supplied (e.g. \code{"black"})
no mapping occurs and all construct will have the same color
irrespective of their value on the \code{map.dim} dimension.}

\item{c.point.cex}{Size of the construct symbols. The default is \code{.8}.
Two values can be entered that will create a size ramp. The values of
\code{map.dim} are mapped onto the ramp.
If only one color size value is supplied (e.g. \code{.8})
no mapping occurs and all construct will have the same size
irrespective of their value on the \code{map.dim} dimension.}

\item{c.label.col}{Color of the construct label. The default is \code{"black"}.
Two values can be entered that will create a color ramp. The values of
\code{map.dim} are mapped onto the ramp.
If only one color color value is supplied (e.g. \code{"black"})
no mapping occurs and all labels will have the same color
irrespective of their value on the \code{map.dim} dimension.}

\item{c.label.cex}{Size of the construct labels. The default is \code{.7}.
Two values can be entered that will create a size ramp. The values of
\code{map.dim} are mapped onto the ramp.
If only one color size value is supplied (e.g. \code{.7})
no mapping occurs and all labels will have the same size
irrespective of their value on the \code{map.dim} dimension.}

\item{c.color.map}{Value range to determine what range of the color ramp defined in
\code{c.color} will be used for mapping. Default is \code{c(.4, ,1)}.
Usually not important for the user.}

\item{c.points.devangle}{The deviation angle from the x-y plane in degrees. These can only be calculated
if a third dimension \code{map.dim} is specified. Only the constructs
that do not depart more than the specified degrees from the
x-y plane will be printed. This facilitates the visual
interpretation, as only vectors represented near the current plane
are shown. Set the value to \code{91} (default)
to show all vectors.}

\item{c.labels.devangle}{The deviation angle from the x-y plane in degrees. These can only be calculated
if a third dimension \code{map.dim} is specified. Only the labels of constructs
that do not depart more than the specified degrees from the
x-y plane will be printed. Set the value to \code{91} (default)
to show all construct labels.}

\item{c.points.show}{Whether the constructs are printed (default is \code{TRUE}).
\code{FALSE} will suppress the printing of the constructs.
To only print certain constructs a numeric vector can be
provided (e.g. \code{c(1:10)}).}

\item{c.labels.show}{Whether the construct labels are printed (default is \code{TRUE}).
\code{FALSE} will suppress the printing of the labels.
To only print certain construct labels a numeric vector can be
provided (e.g. \code{c(1:10)}).}

\item{e.points.show}{Whether the elements are printed (default is \code{TRUE}).
\code{FALSE} will suppress the printing of the elements.
To only print certain elements a numeric vector can be
provided (e.g. \code{c(1:10)}).}

\item{e.labels.show}{Whether the element labels are printed (default is \code{TRUE}).
\code{FALSE} will suppress the printing of the labels.
To only print certain element labels a numeric vector can be
provided (e.g. \code{c(1:10)}).}

\item{inner.positioning}{Logical. Whether to calculate positions to minimize overplotting of
elements and construct labels (default is\code{TRUE}). Note that
the positioning may slow down the plotting.}

\item{outer.positioning}{Logical. Whether to calculate positions to minimize overplotting of
of construct labels on the outer borders (default is\code{TRUE}). Note that
the positioning may slow down the plotting.}

\item{c.labels.inside}{Logical. Whether to print construct labels next to the points.
Can be useful during inspection of the plot (default \code{FALSE}).}

\item{c.lines}{Logical. Whether construct lines from the center of the biplot
to the surrounding box are drawn (default is \code{FALSE}).}

\item{col.c.lines}{The color of the construct lines from the center to the borders
of the plot (default is \code{gray(.9)}).}

\item{flipaxes}{Logical vector of length two. Whether x and y axes are reversed
(default is \code{c(F,F)}).}

\item{strokes.x}{Length of outer strokes in x direction in NDC.}

\item{strokes.y}{Length of outer strokes in y direction in NDC.}

\item{offsetting}{Do offsetting? (TODO)}

\item{offset.labels}{Offsetting parameter for labels (TODO).}

\item{offset.e}{offsetting parameter for elements (TODO).}

\item{axis.ext}{Axis extension factor (default is \code{.1}). A bigger value will
zoom out the plot.}

\item{mai}{Margins available for plotting the labels in inch
(default is \code{c(.2, 1.5, .2, 1.5)}).}

\item{rect.margins}{Vector of length two (default is \code{c(.07, .07)}). Two values
specifying the additional horizontal and vertical margin around each
label.}

\item{srt}{Angle to rotate construct label text. Only used in case \code{offsetting=FALSE}.}

\item{cex.pos}{Cex parameter used during positioning of labels if prompted. Does
usually not have to be changed by user.}

\item{xpd}{Logical (default is \code{TRUE}). Whether to extend text labels
over figure region. Usually not needed by the user.}

\item{unity}{Scale elements and constructs coordinates to unit scale in 2D (maximum of 1)
so they are printed more neatly (default \code{TRUE}).}

\item{unity3d}{Scale elements and constructs coordinates to unit scale in 3D (maximum of 1)
so they are printed more neatly (default \code{TRUE}).}

\item{scale.e}{Scaling factor for element vectors. Will cause element points to move a bit more
to the center. (but only if \code{unity} or \code{unity3d} is \code{TRUE}).
This argument is for visual appeal only.}

\item{zoom}{Scaling factor for all vectors. Can be used to zoom
the plot in and out (default \code{1}).}

\item{var.show}{Show explained sum-of-squares in biplot? (default \code{TRUE}).}

\item{var.cex}{The cex value for the percentages shown in the plot.}

\item{var.col}{The color value of the percentages shown in the plot.}

\item{...}{parameters passed on to  come.}
}
\description{
The biplot is the central way to create a joint plot of elements and constructs. Depending on the parameters chosen
it contains information on the distances between elements and constructs. Also the relative values the elements have
on a construct can be read off by projection the element onto the construct vector. A lot of parameters can be
changed rendering different types of biplots (ESA, Slater's) and different looks (colors, text size). See the
example section below to get started.
}
\details{
For the construction of a biplot the grid matrix is first centered and normalized according to the prompted options.

Next, the matrix is decomposed by singular value decomposition (SVD)
into \deqn{X = UDV^T}{X = UDV^T}
The biplot is made up of two matrices
\deqn{X = GH^T}{X = GH^T}
These matrices are construed on the basis of the SVD results.
\deqn{\hat{X} = UD^gD^hV^T}{X = UD^gD^hV^T}
Note that the grid matrix values are only recovered and
the projection property is only given if \eqn{g + h = 1}{g + h = 1}
}
\examples{
\dontrun{

biplot2d(boeker) # biplot of boeker data
biplot2d(boeker, c.lines = T) # add construct lines
biplot2d(boeker, center = 2) # with column centering
biplot2d(boeker, center = 4) # midpoint centering
biplot2d(boeker, normalize = 1) # normalization of constructs

biplot2d(boeker, dim = 2:3) # plot 2nd and 3rd dimension
biplot2d(boeker, dim = c(1, 4)) # plot 1st and 4th dimension

biplot2d(boeker, g = 1, h = 1) # assign singular values to con. & elem.
biplot2d(boeker, g = 1, h = 1, center = 1) # row centering (Slater)
biplot2d(boeker, g = 1, h = 1, center = 4) # midpoint centering (ESA)

biplot2d(boeker, e.color = "red", c.color = "blue") # change colors
biplot2d(boeker, c.color = c("white", "darkred")) # mapped onto color range

biplot2d(boeker, unity = T) # scale con. & elem. to equal length
biplot2d(boeker, unity = T, scale.e = .5) # scaling factor for element vectors

biplot2d(boeker, e.labels.show = F) # do not show element labels
biplot2d(boeker, e.labels.show = c(1, 2, 4)) # show labels for elements 1, 2 and 4
biplot2d(boeker, e.points.show = c(1, 2, 4)) # only show elements 1, 2 and 4
biplot2d(boeker, c.labels.show = c(1:4)) # show constructs labels 1 to 4
biplot2d(boeker, c.labels.show = c(1:4)) # show constructs labels except 1 to 4

biplot2d(boeker, e.cex.map = 1) # change size of texts for elements
biplot2d(boeker, c.cex.map = 1) # change size of texts for constructs

biplot2d(boeker, g = 1, h = 1, c.labels.inside = T) # constructs inside the plot
biplot2d(boeker,
  g = 1, h = 1, c.labels.inside = T, # different margins and elem. color
  mai = c(0, 0, 0, 0), e.color = "red"
)

biplot2d(boeker, strokes.x = .3, strokes.y = .05) # change length of strokes

biplot2d(boeker, flipaxes = c(T, F)) # flip x axis
biplot2d(boeker, flipaxes = c(T, T)) # flip x and y axis

biplot2d(boeker, outer.positioning = F) # no positioning of con.-labels

biplot2d(boeker, c.labels.devangle = 20) # only con. within 20 degree angle
}

}
\seealso{
\itemize{
\item Unsophisticated biplot: \code{\link[=biplotSimple]{biplotSimple()}};
\item 2D biplots:\code{\link[=biplot2d]{biplot2d()}}, \code{\link[=biplotEsa2d]{biplotEsa2d()}}, \code{\link[=biplotSlater2d]{biplotSlater2d()}};
\item Pseudo 3D biplots: \code{\link[=biplotPseudo3d]{biplotPseudo3d()}}, \code{\link[=biplotEsaPseudo3d]{biplotEsaPseudo3d()}}, \code{\link[=biplotSlaterPseudo3d]{biplotSlaterPseudo3d()}};
\item Interactive 3D biplots: \code{\link[=biplot3d]{biplot3d()}}, \code{\link[=biplotEsa3d]{biplotEsa3d()}}, \code{\link[=biplotSlater3d]{biplotSlater3d()}};
\item Function to set view in 3D: \code{\link[=home]{home()}}
}
}
