\name{biplotSlaterPseudo3d}
\alias{biplotSlaterPseudo3d}
\title{Draws Slater's biplot in 2D with depth impression (pseudo 3D).}
\usage{biplotSlaterPseudo3d(x, center=1, g=1, h=1, ...)
}
\description{Draws Slater's biplot in 2D with depth impression (pseudo 3D).
The default is to use row centering 
and no normalization. Note that Slater's biplot is just a special 
case of a biplot that can be produced using the \code{\link{biplotPseudo3d}} 
function with the arguments \code{center=1, g=1, h=1}.
Here, only the arguments that are modified for Slater's biplot are described.
To see all the parameters that can be changed see \code{\link{biplot2d}}
and \code{\link{biplotPseudo3d}}.}
\author{Mark Heckmann}
\seealso{Unsophisticated biplot: \code{\link{biplotSimple}}; \cr
2D biplots:
\code{\link{biplot2d}},
\code{\link{biplotEsa2d}},
\code{\link{biplotSlater2d}};\cr
Pseudo 3D biplots:
\code{\link{biplotPseudo3d}},  
\code{\link{biplotEsaPseudo3d}},
\code{\link{biplotSlaterPseudo3d}};\cr
Interactive 3D biplots:
\code{\link{biplot3d}},
\code{\link{biplotEsa3d}},
\code{\link{biplotSlater3d}};\cr
Function to set view in 3D:
\code{\link{home}}.}
\arguments{\item{x}{\code{repgrid} object.}
\item{center}{Numeric. The type of centering to be performed. 
0= no centering, 1= row mean centering (construct), 
2= column mean centering (elements), 3= double-centering (construct and element means),
4= midpoint centering of rows (constructs).
Slater's biplot uses \code{1} (row centering).}
\item{g}{Power of the singular value matrix assigned to the left singular 
vectors, i.e. the constructs.}
\item{h}{Power of the singular value matrix assigned to the right singular 
vectors, i.e. the elements.}
\item{...}{Additional parameters for be passed to \code{\link{biplotPseudo3d}}.}
}
\examples{\dontrun{
# See examples in \code{\link{biplotPseudo3d}} as the same arguments
# can used for this function.
}}

