\name{biplotSimple}
\alias{biplotSimple}
\title{A graphically unsophisticated version of a biplot.}
\usage{
  biplotSimple(x, dim = 1:2, center = 1, normalize = 0,
    g = 0, h = 1 - g, unity = T, col.active = NA,
    col.passive = NA, scale.e = 0.9, zoom = 1,
    e.point.col = "black", e.point.cex = 1,
    e.label.col = "black", e.label.cex = 0.7,
    c.point.col = grey(0.6), c.label.col = grey(0.6),
    c.label.cex = 0.6, ...)
}
\arguments{
  \item{x}{\code{repgrid} object.}

  \item{dim}{Dimensions (i.e. principal components) to be
  used for biplot (default is \code{c(1,2)}).}

  \item{center}{Numeric. The type of centering to be
  performed.  0= no centering, 1= row mean centering
  (construct), 2= column mean centering (elements), 3=
  double-centering (construct and element means), 4=
  midpoint centering of rows (constructs).  The default is
  \code{1} (row centering).}

  \item{normalize}{A numeric value indicating along what
  direction (rows, columns) to normalize by standard
  deviations. \code{0 = none, 1= rows, 2 = columns}
  (default is \code{0}).}

  \item{g}{Power of the singular value matrix assigned to
  the left singular vectors, i.e. the constructs.}

  \item{h}{Power of the singular value matrix assigned to
  the right singular vectors, i.e. the elements.}

  \item{col.active}{Columns (elements) that are no
  supplementary points, i.e. they are used in the SVD to
  find principal components. default is to use all
  elements.}

  \item{col.passive}{Columns (elements) that are
  supplementary points, i.e. they are NOT used in the SVD
  but projecte into the component space afterwards. They do
  not determine the solution. Default is \code{NA}, i.e. no
  elements are set supplementary.}

  \item{unity}{Scale elements and constructs coordinates to
  unit scale in 2D (maximum of 1) so they are printed more
  neatly (default \code{TRUE}).}

  \item{zoom}{Scaling factor for all vectors. Can be used
  to zoom the plot in and out (default \code{1}).}

  \item{scale.e}{Scaling factor for element vectors. Will
  cause element points to move a bit more to the center.
  This argument is for visual appeal only.}

  \item{e.point.col}{Color of the element symbols (default
  is \code{"black"}.}

  \item{e.point.cex}{Size of the element symbol (default is
  \code{1}.}

  \item{e.label.col}{Color of the element labels (default
  is \code{"black"}.}

  \item{e.label.cex}{Size of the element labels (default is
  \code{.7}.}

  \item{c.point.col}{Color of the construct lines (default
  is \code{grey(.6)}.}

  \item{c.label.col}{Color of the construct labels (default
  is \code{grey(.6)}.}

  \item{c.label.cex}{Size of the costruct labels (default
  is \code{.6}.}

  \item{...}{Parameters to be passed on to \code{center()}
  and \code{normalize}.}
}
\value{
  \code{repgrid} object.
}
\description{
  It will draw elements and constructs vectors using
  similar arguments as \code{\link{biplot2d}}. It is a
  version for quick exploration used during development.
}
\examples{
\dontrun{

   biplotSimple(boeker)
   biplotSimple(boeker, unity=F)

   biplotSimple(boeker, g=1, h=1)              # INGRID biplot
   biplotSimple(boeker, g=1, h=1, center=4)    # ESA biplot

   biplotSimple(boeker, zoom=.9)               # zooming out
   biplotSimple(boeker, scale.e=.6)            # scale element vectors

   biplotSimple(boeker, e.point.col="brown")   # change colors
   biplotSimple(boeker, e.point.col="brown",
                c.label.col="darkblue")
}
}
\author{
  Mark Heckmann
}
\seealso{
  Unsophisticated biplot: \code{\link{biplotSimple}}; \cr
  2D biplots: \code{\link{biplot2d}},
  \code{\link{biplotEsa2d}},
  \code{\link{biplotSlater2d}};\cr Pseudo 3D biplots:
  \code{\link{biplotPseudo3d}},
  \code{\link{biplotEsaPseudo3d}},
  \code{\link{biplotSlaterPseudo3d}};\cr Interactive 3D
  biplots: \code{\link{biplot3d}},
  \code{\link{biplotEsa3d}},
  \code{\link{biplotSlater3d}};\cr Function to set view in
  3D: \code{\link{home}}.
}

