% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subtr_bg.R
\name{subtr_bg}
\alias{subtr_bg}
\alias{subtr_bg.formula}
\alias{subtr_bg.data.frame}
\alias{subtr_bg.default}
\title{Automated background subtraction for spectral data}
\usage{
subtr_bg(x, ...)

\method{subtr_bg}{formula}(formula, data = NULL, ...)

\method{subtr_bg}{data.frame}(x, ...)

\method{subtr_bg}{default}(x, y, degree = 8, raw = FALSE, make_rel = TRUE, ...)
}
\arguments{
\item{x}{a numeric vector containing the spectral wavenumbers; alternatively
a data frame containing spectral data as \code{"wavenumber"} and
\code{"intensity"} can be supplied.}

\item{formula}{an object of class '\code{\link[stats]{formula}}' of the form
\code{intensity ~ wavenumber}.}

\item{data}{a data frame containing the variables in \code{formula}.}

\item{y}{a numeric vector containing the spectral intensities.}

\item{degree}{the degree of the polynomial. Must be less than the number of
unique points when raw is \code{FALSE}. Typically a good fit can be
found with a 8th order polynomial.}

\item{raw}{if \code{TRUE}, use raw and not orthogonal polynomials.}

\item{make_rel}{logical; if \code{TRUE} spectra are automatically normalized
with \code{\link{make_rel}()}.}

\item{\ldots}{further arguments passed to \code{\link[stats]{poly}()}.}
}
\value{
\code{subtr_bg()} returns a data frame containing two columns named
\code{"wavenumber"} and \code{"intensity"}.
}
\description{
This baseline correction routine iteratively finds the baseline of a spectrum
using a polynomial fitting.
}
\details{
This is a translation of Michael Stephen Chen's MATLAB code written for the
\code{imodpolyfit} routine from Zhao et al. 2007.
}
\examples{
data("raman_hdpe")

subtr_bg(raman_hdpe)

}
\references{
Chen MS (2020). Michaelstchen/ModPolyFit. \emph{MATLAB}.
Retrieved from \url{https://github.com/michaelstchen/modPolyFit}
(Original work published July 28, 2015)

Zhao J, Lui H, McLean DI, Zeng H (2007). “Automated Autofluorescence
Background Subtraction Algorithm for Biomedical Raman Spectroscopy.”
\emph{Applied Spectroscopy}, \strong{61}(11), 1225–1232.
\doi{10.1366/000370207782597003}.
}
\seealso{
\code{\link[stats]{poly}()};
\code{\link{smooth_intens}()}
}
\author{
Win Cowger, Zacharias Steinmetz
}
