% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_norm.R
\name{adj_res}
\alias{adj_res}
\alias{conform_res}
\alias{adj_neg}
\alias{mean_replace}
\alias{is_empty_vector}
\title{Normalization and conversion of spectral data}
\usage{
adj_res(x, res = 1, fun = round)

conform_res(x, res = 5)

adj_neg(y, na.rm = FALSE)

mean_replace(y, na.rm = TRUE)

is_empty_vector(x)
}
\arguments{
\item{x}{a numeric vector or an \R object which is coercible to one by
\code{as.vector(x, "numeric")}; \code{x} should contain the spectral
wavenumbers.}

\item{res}{spectral resolution supplied to \code{fun}.}

\item{fun}{the function to be applied to each element of \code{x}; defaults
to \code{\link[base]{round}()} to round to a specific resolution \code{res}.}

\item{y}{a numeric vector containing the spectral intensities.}

\item{na.rm}{logical. Should missing values be removed?}
}
\value{
\code{adj_res()} and \code{conform_res()} return a numeric vector with
resolution-conformed wavenumbers.
\code{adj_neg()} and \code{make_rel()} return numeric vectors
with the normalized intensity data.
}
\description{
\code{adj_res()} and \code{conform_res()} are helper functions to align
wavenumbers in terms of their spectral resolution.
\code{adj_neg()} converts numeric intensities \code{y} < 1 into values >= 1,
keeping absolute differences between intensity values by shifting each value
by the minimum intensity.
\code{make_rel()} converts intensities \code{y} into relative values between
0 and 1 using the standard normalization equation.
If \code{na.rm} is \code{TRUE}, missing values are removed before the
computation proceeds.
}
\details{
\code{adj_res()} and \code{conform_res()} are used in Open Specy to
facilitate comparisons of spectra with different resolutions.
\code{adj_neg()} is used to avoid errors that could arise from log
transforming spectra when using \code{\link{adj_intens}()} and other
functions.
\code{make_rel()} is used to retain the relative height proportions between
spectra while avoiding the large numbers that can result from some spectral
instruments.
}
\examples{
adj_res(seq(500, 4000, 4), 5)
conform_res(seq(500, 4000, 4))
adj_neg(c(-1000, -1, 0, 1, 10))
make_rel(c(-1000, -1, 0, 1, 10))

}
\seealso{
\code{\link[base]{min}()} and \code{\link[base]{round}()};
\code{\link{adj_intens}()} for log transformation functions;
\code{\link{conform_spec}()} for conforming wavenumbers of an
\code{OpenSpecy} object to be matched with a reference library
}
\author{
Win Cowger, Zacharias Steinmetz
}
