% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OralOpioids.R
\name{MED}
\alias{MED}
\title{Get the Morphine Equivalent Dose (MED) by using the DIN or NDC}
\usage{
MED(Drug_ID, Opioid_Table)
}
\arguments{
\item{Drug_ID}{A numeric value for the DIN or NDC. Exclude all zeros in front.}

\item{Opioid_Table}{Opioid dataset which can be loaded by using
the \code{load_HealthCanada_Opioid_Table()} or \code{load_FDA_Opioid_Table()} function. The name you use to call the function should be input here.}
}
\value{
MED: Morphine Equivalent Dose
}
\description{
\code{MED} retrieves the Morphine Equivalent Dose from the Opioid_Table.
}
\examples{

FDA_Opioid_Table <- load_Opioid_Table(no_download = TRUE, country="US")
HealthCanada_Opioid_Table <- load_Opioid_Table(no_download = TRUE, country="Canada")
MED(786535, HealthCanada_Opioid_Table)
MED("0093-0058", FDA_Opioid_Table)
}
