% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loss_functions.R
\name{cumulative_loss}
\alias{cumulative_loss}
\title{Cumulative Loss}
\usage{
cumulative_loss(centers, observations)
}
\arguments{
\item{centers}{a matrix containing m centers of length d, where each row corresponds to coordinates of a center.}

\item{observations}{a matrix containing T observations of length d, where each row of the matrix is an observation of length d.}
}
\value{
The sum of squared Euclidean distance of each of T observations in matrix \code{observations} to its nearest center within \code{centers}.
}
\description{
This function computes the sum of squared Euclidean distance of each observation to its nearest center.
}
\details{
Given a set \emph{C} of m centers of length d (\emph{i.e.,} \emph{C} = \eqn{{c_{1}, c_{2}, \dots, c_{m}}}) and a set \emph{X} of T observations of length d (\emph{i.e.,} \emph{X} = \eqn{{x_{1}, x_{2}, \dots, x_{T}}}), this function computes the sum of squared euclidean distance of each observation in X to its nearest center in \emph{C}, \emph{i.e.,} \deqn{S_{T}(C) =\sum_{t=1,2,\dots,T} min_{1<= i <= m}|x_{t}-c_{i}|_{2}^{2}.}
}
\examples{
## generating 4 centers of length 3.
centers <- matrix(1:12, nrow = 4, ncol = 3)
## generating 10 observations of length 3.
observations <- matrix(rmnorm(10, mean = c(0,3,5), varcov = diag(1,3)), nrow = 10)
cumulative_loss(centers, observations)
}
\keyword{internal}

