% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimUMAPPlot.R
\name{dimUMAPPlot}
\alias{dimUMAPPlot}
\title{dimUMAPPlot Function}
\usage{
dimUMAPPlot(
  data_object,
  nPC = 30,
  gene_oi,
  group_column,
  plotname = NULL,
  repel = FALSE,
  filePATH = NULL,
  fileName = NULL
)
}
\arguments{
\item{data_object}{Input \emph{PALMO} S4 object. Contains annotation table and
single cell data stored as Seurat scRNA object.}

\item{nPC}{Number of PCAs to be used for UMAP, Default is 30}

\item{gene_oi}{Genes of interest to explore, required}

\item{group_column}{User-defined group name column from annotation table or
Seurat annotation column. Example, group_column='celltype' (required)}

\item{plotname}{User-defined output file name (required)}

\item{repel}{UMAP plot with labels repel=TRUE. Default FALSE}

\item{filePATH}{User-defined output directory \emph{PATH} Default, current
directory}

\item{fileName}{User-defined file name, Default outputFile}
}
\value{
UMAP plot
}
\description{
This function allows to perform UMAP visualization of gene of interest list.
}
\examples{
\dontrun{
dimUMAPPlot(data_object=pamo_obj, nPC=15, gene_oi=stable_gene,
group_column='celltype', plotname='stable')
}
}
\keyword{dimUMAPPlot}
