% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDatabase.R
\name{addDatabase}
\alias{addDatabase}
\title{Add a Database to a PAMpalSettings Object}
\usage{
addDatabase(pps, db = NULL, verbose = TRUE)
}
\arguments{
\item{pps}{a \linkS4class{PAMpalSettings} object to add a database to}

\item{db}{a database to add}

\item{verbose}{logical flag to show messages}
}
\value{
the same \linkS4class{PAMpalSettings} object as pps, with the database
  \code{db} added to the "db" slot
}
\description{
Adds a new function to the "function" slot in a PAMpalSettings
  object. Interactively asks for database files if none are supplied as input
}
\examples{

# not recommended to create a pps like this, for example only
pps <- new('PAMpalSettings')
db <- system.file('extdata', 'Example.sqlite3', package='PAMpal')
pps <- addDatabase(pps, db)
pps

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
