% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeEventClips.R
\name{writeEventClips}
\alias{writeEventClips}
\title{Create Wav Clips of Data}
\usage{
writeEventClips(
  x,
  buffer = c(-0.1, 0.1),
  outDir = ".",
  mode = c("event", "detection"),
  channel = 1,
  progress = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{x}{\linkS4class{AcousticStudy} object containing data to make wav clips for}

\item{buffer}{amount before and after each event to also include in the clip, in seconds.
Can either be a vector of length two specifying how much to buffer before and after
(first number should be negative), or a single value if the buffer amount should be identical.}

\item{outDir}{directory to write clips to, defaults to current directory}

\item{mode}{either \code{'event'} or \code{'detection'} specifying whether to create
wav clips of entire events or individual detections}

\item{channel}{channel(s) of clips to write}

\item{progress}{logical flag to show progress bar}

\item{verbose}{logical flag to show summary messages}
}
\value{
A vector of file names for the wav clips that were successfully
  created, any that were not able to be written will be \code{NA}. Note
  that currently this can only write clips with up to 2 channels. File names
  will be formatted as
  [Event or Detection]_[EventId]CH[ChannelNumber(s)]_[YYYYMMDDHHMMSS]_[mmm].wav
  (the last numbers are the start time of the file in UTC, accurate to milliseconds)
}
\description{
Creates audio clips containing sounds from events or detections
}
\examples{

data(exStudy)
recs <- system.file('extdata', 'Recordings', package='PAMpal')
exStudy <- addRecordings(exStudy, folder=recs, log=FALSE, progress=FALSE)
\dontrun{
# not running so that no wav clips are written to disk
wavs <- writeEventClips(exStudy, outDir='WavFolder', mode='event')
}

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
