% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateDeployment.R
\name{evaluateDeployment}
\alias{evaluateDeployment}
\title{Evaluate deployment of recording files for potential problems}
\usage{
evaluateDeployment(
  dir,
  excludeDirs = c("Post_Retrieval_Data", "Pre_Deployment_Data"),
  sampleWindow = c(60, 120),
  channel = 1,
  sensitivity = NA,
  calibration = NULL,
  timeRange = NULL,
  name = NULL,
  subDirPattern = NULL,
  outDir = NULL,
  nSpectrograms = 0,
  specLength = 1800,
  panelLength = 300,
  log = FALSE,
  progress = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{dir}{folder or folders containing recordings and optionally Soundtrap
.log.xml files. All .wav and .log.xml files within \code{dir} will be
analysed, as well as all files in each subfolder of \code{dir} (only
going down one level).}

\item{excludeDirs}{the names of any subfolders within \code{dir} that
should be excluded (e.g. if \code{dir} contains folders "Recordings" and
"Clips" then \code{excludeDirs="Clips"} would result in only the "Recordings"
folder being analysed}

\item{sampleWindow}{start and end (in seconds) of the time window to use
for analysis, e.g. \code{c(40, 100)} will use a 60 second window starting
40 seconds into the file}

\item{channel}{channel number of recording files to use for analysis}

\item{sensitivity}{the sensitivity of the recording device in dB, this
is typically a large negative number}

\item{calibration}{if not \code{NULL}, the frequency dependent calibration
to apply. Must have "frequency" and "gain" (in dB), can either be a .tf
file, a CSV file with columns for frequency and gain, or a dataframe with
columns frequency and gain}

\item{timeRange}{if not \code{NULL}, a vector of two POSIXct times identifying
the expected start and end times of the deployment. If the actual start and
end times of of the recording files are earlier or later than these, then
a warning will be issued and no calculations will be done, returning
\code{NULL}}

\item{name}{a name to assign for this deployment, used for plot labeling,
logging, and stored as \code{projectName} with the output dataframe. If
left as \code{NULL}, then the basename of \code{dir} will be used.}

\item{subDirPattern}{if not \code{NULL}, a pattern to use for selecting
which subfolders of \code{dir} to use for analysis. E.g. if folders
"Site1_Recordings" and "Site2_Recordings" both exist in \code{dir}, then
\code{subDirPattern="^Site1"} would result in analysing only the first
folder of recordings}

\item{outDir}{if not \code{NULL}, a directory to store outputs. Outputs include
plots, a CSV of the calculated metrics, and a .txt log file if \code{log=TRUE}}

\item{nSpectrograms}{number of spectrogram images to generate. Recording files
for creating the spectrograms will be approximately evenly spaced throughout
the deployment - if \code{nSpectrograms=5}, then the first recording will be
randomly chosen from the first 20\% of files, the second from the second 20\%,
etc.}

\item{specLength}{length of spectrograms to create, in seconds}

\item{panelLength}{length of each panel of the spectrogram plot, in seconds.
This must be less than \code{specLength}, and is used to avoid creating
awkwardly long plots. If \code{specLength=360} and \code{panelLength=60},
then the result will be a 6 panel plot where each section is 60 seconds long}

\item{log}{if \code{TRUE} and \code{outDir} is not \code{NULL}, then a text
file named "(name)_EvaluateRecorder_LogFile.txt" will be created in
\code{outDir} logging progress and warning messages}

\item{progress}{logical flag to show a progress bar}

\item{verbose}{logical flag to show some messages}
}
\value{
a dataframe of the QAQC metric outputs for each recording file
}
\description{
Runs a number of quality assurance / quality control (QAQC)
checks on a folder of recording files to identify potential problems.
These include checking the start and end times of files for consistency
to identify potential data gaps, measuring sound levels in each file
to identify potential recorder issues, and (if applicable) checking
battery and temperature data to identify potential instrument failure.
Can also create spectrogram images throughout the deployment to aid in
visually checking for problems or noise.
}
