% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPSD.R
\name{plotPSD}
\alias{plotPSD}
\alias{prepPSDData}
\title{Plot Power Spectral Density}
\usage{
plotPSD(
  x,
  style = c("quantile", "density"),
  scale = c("log", "linear"),
  q = 0.5,
  color = "black",
  freqRange = NULL,
  dbRange = NULL,
  dbInt = 1,
  units = "dB re: 1uPa^2/Hz",
  cmap = viridis_pal()(25),
  title = NULL,
  progress = TRUE
)

prepPSDData(
  x,
  freqRange = NULL,
  style = c("density", "quantile"),
  dbInt = 1,
  progress = TRUE
)
}
\arguments{
\item{x}{a dataframe or list of dataframes, or file path or vector
of file paths, or the output from \code{prepPSDData}}

\item{style}{character specifying plot style to create, either
"quantile", "density", or a vector with both}

\item{scale}{scale to use for frequency axis, one of "log" or "linear"}

\item{q}{quantile to plot}

\item{color}{color for quantile}

\item{freqRange}{range of frequencies to plot}

\item{dbRange}{range of dB values to plot}

\item{dbInt}{bin interval size for density plot}

\item{units}{units for dB axis of plot}

\item{cmap}{color map to use for density plot}

\item{title}{optional title for plot}

\item{progress}{logical flag to show progress bar}
}
\value{
a ggplot object for \code{plotPSD}, see details for \code{prepPSDData}
}
\description{
Plots the distribution of summarised sound levels
across frequency, either as lines of quantile levels or a
heatmap showing the full distribution. Multiple PSD sources
can be combined and plotted as long as they have identical
frequency levels.
}
\details{
\code{prepPSDData} is called by the plotting code, and
does not necessarily need to be called separately from
\code{plotPSD}. Loading PSD data can be time consuming, so
it may be useful to load the data first, then it is easier
to spend time adjusting plot settings.

The output of \code{prepPSDData} is a list with 5 elements:
\itemize{
\item{frequency}{ - the frequency values of the input data}
\item{freqRange}{ - the value of the "freqRange" parameter if
it was supplied}
\item{dbVals}{ - the dB values of breakpoints used for "density"
plotting}
\item{quantileData}{ - the data used for quantile plots. These
are stored as "tidgest" objects serialized using
\link[tdigest]{as.list.tdigest}, from which quantiles can
be computed}
\item{densityData}{ - the data used fro quantile plots. These
are stored as a matrix of bin counts - each column corresponds
to the "frequency" output, each row corresponds to bins defined
using "dbVals" as boundaries}
}
}
\examples{

psd <- checkSoundscapeInput(system.file('extdata/PSDSmall.csv', package='PAMscapes'))
# Plotting only first 1000 columns for brevity
plotPSD(psd[1:1000], style='density')
plotPSD(psd[1:1000], style='quantile', q=.05)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
