% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLTSA.R
\name{plotLTSA}
\alias{plotLTSA}
\title{Plot Long-Term Spectral Average (LTSA)}
\usage{
plotLTSA(
  x,
  bin = "1hour",
  scale = c("log", "linear"),
  title = NULL,
  freqRange = NULL,
  dbRange = NULL,
  units = NULL,
  cmap = viridis_pal()(25),
  toTz = "UTC"
)
}
\arguments{
\item{x}{a soundscape metric file that can be read in with
\link{checkSoundscapeInput}, or a dataframe with \code{UTC},
\code{frequency}, and \code{value}}

\item{bin}{amount of time to bin for each LTSA slice, format can
be "#Unit" e.g. \code{'2hour'} or \code{'1day'}}

\item{scale}{scaling for frequency axis, one of \code{log} or \code{linear}}

\item{title}{optional title for plot}

\item{freqRange}{if not \code{NULL}, a vector of two numbers specifying the
range of frequencies (Hz) to plot. Providing \code{NA} for either value will
use the max/min frequency present in the dataset}

\item{dbRange}{if not \code{NULL}, a fixed limit to use for the color
scaling of dB values in the plot}

\item{units}{units for plot labeling, will attempt to read them from the input}

\item{cmap}{color palette map to use for plot, default is \link[scales]{viridis_pal}}

\item{toTz}{timezone to use for the time axis (input data must be UTC).
Specification must be from \link{OlsonNames}}
}
\value{
ggplot object of the LTSA plot
}
\description{
Creates a long-term spectral average (LTSA) style plot
of the data, a plot where the x-axis is time and the y-axis is frequency.
Color represents the magnitude of sound. In order to compress the
time axis, data are binned into time chunks and the median value
within that time bin is displayed
}
\examples{
hmd <- checkSoundscapeInput(system.file('extdata/MANTAExampleSmall1.csv', package='PAMscapes'))
# time range is too small for nice plots
plotLTSA(hmd, bin='1min', title='Every Minute')
plotLTSA(hmd, bin='2min', title='2 Minute Bins')


}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
