% Generated by roxygen2 (4.0.2): do not edit by hand
\name{getnfac}
\alias{getnfac}
\title{Determining The Number of Factors In Approximate Factor Model}
\usage{
getnfac(x,kmax,jj)
}
\arguments{
\item{x}{A NxT matrix containing the data.}

\item{kmax}{The maximum number of common factors used to compute the criterion
function for the estimate of ic, the number of common factors. This methedology
is weak to underestimation of the number of common factors. It is suggested
that overestimation is preferred.}

\item{jj}{an Integer 1 through 8. Choices 1 through 7 are respectively, IC(1),
IC(2), IC(3), AIC(1), BIC(1), AIC(3), and BIC(3), respectively. Choosing 8
makes the number of factors equal to the number of columns whose sum of
eigenvalues is less than  or equal to .5.}
}
\value{
ic The approximate number of factors based off of the chosen.
penalty function

lambda Estimated factor loadings associated with common factors.

Fhat Estimated common component
}
\description{
This function approximates the number of factors in an approximate factor model
 for large N by T matrices using the methods found in Bai and Ng (2002)
}
\details{
This function approximates the number of factors in an approximate
factor model. Amongst the penalty functions BIC(3) has been found to be
strict against cross-sectional dependence and is recommended for large
matrices. IC(1), IC(2), and IC(3) . AIC(1) will not work for all N and T.
BIC(1) will not work for small N relative to T. AIC(3) and BIC(3) take into
account the panel structure of the data. AIC(3) performs in consistently
across configurations of the data while BIC(3) may not perform well for some
configurations.
}
\references{
Jushan, and Serena Ng. "Determining the Number of Factors in
Approximate Factor Models." Econometrica 70.1 (2002): 191-221. Print.
}

