% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apfp.R
\name{apfp}
\alias{apfp}
\title{Model-based Clustering with APFP}
\usage{
apfp(tuning, K = NULL, lambda = NULL, y, N = 100, kms.iter = 100, kms.nstart = 100,
      adapt.kms = FALSE, eps.diff = 1e-5, eps.em = 1e-5,
      iter.LQA = 20, eps.LQA = 1e-5, model.crit = 'gic')
apfp(tuning = NULL, K, lambda, y, N = 100, kms.iter = 100, kms.nstart = 100,
      adapt.kms = FALSE, eps.diff = 1e-5, eps.em = 1e-5,
      iter.LQA = 20, eps.LQA = 1e-5, model.crit = 'gic')
}
\arguments{
\item{tuning}{A 2-dimensional vector or a matrix with 2 columns, the first column is the number of clusters \eqn{K} and the second column is the tuning parameter \eqn{\lambda} in the penalty term. If this is missing, then \code{K} and \code{lambda} must be provided.}

\item{K}{The number of clusters \eqn{K}.}

\item{lambda}{The tuning parameter \eqn{\lambda} in the penalty term.}

\item{y}{A p-dimensional data matrix. Each row is an observation.}

\item{N}{The maximum number of iterations in the EM algorithm. The default value is 100.}

\item{kms.iter}{The maximum number of iterations in kmeans algorithm for generating the starting value for the EM algorithm.}

\item{kms.nstart}{The number of starting values in K-means.}

\item{adapt.kms}{A indicator of using the cluster means estimated by K-means to calculate the adaptive parameters in APFP. The default value is FALSE.}

\item{eps.diff}{The lower bound of pairwise difference of two mean values. Any value lower than it is treated as 0.}

\item{eps.em}{The lower bound for the stopping criterion in the EM algorithm.}

\item{iter.LQA}{The number of iterations in the estimation of cluster means by using the local quadratic approximation (LQA).}

\item{eps.LQA}{The lower bound for the stopping criterion in the estimation of cluster means.}

\item{model.crit}{The criterion used to select the number of clusters \eqn{K}. It is either `bic' for Bayesian Information Criterion or `gic' for Generalized Information Criterion.}
}
\value{
This function returns the esimated parameters and some statistics of the optimal model within the given \eqn{K} and \eqn{\lambda}, which is selected by BIC when \code{model.crit = 'bic'} or GIC when \code{model.crit = 'gic'}.
\item{mu.hat.best}{The estimated cluster means in the optimal model}
\item{sigma.hat.best}{The estimated covariance in the optimal model}
\item{p.hat.best}{The estimated cluster proportions in the optimal model}
\item{s.hat.best}{The clustering assignments using the optimal model}
\item{lambda.best}{The value of \eqn{\lambda} that provide the optimal model}
\item{K.best}{The value of \eqn{K} that provide the optimal model}
\item{llh.best}{The log-likelihood of the optimal model}
\item{gic.best}{The GIC of the optimal model}
\item{bic.best}{The BIC of the optimal model}
\item{ct.mu.best}{The degrees of freedom in the cluster means of the optimal model}
}
\description{
The adaptive pairwise fusion penalty (APFP) was proposed by Guo (2010). Under the framework of the model-based clustering, APFP aims to identify the pairwise informative variables for clustering high-dimenisonal data.
}
\details{
The j-th variable is defined as pairwise informative for a pair of clusters \eqn{C_k} and \eqn{C_{k'}} if \eqn{\mu_{kj} \neq \mu_{k'j}}. Also, a variable is globally informative if it is pairwise informative for at least one pair of clusters. Here we assume that each cluster has the same diagonal variance in the model-based clustering. APFP is in the following form,
\deqn{\sum_{j=1}^d \sum_{k<k'}\tau_{kk'j}|\mu_{kj} - \mu_{k'j}|,}
where \eqn{d} is the number of variables in the data, \eqn{\tau_{kk'j} = |\tilde{\mu}_{kj} - \tilde{\mu}_{k'j}|^{-1}} is the adaptive parameters. Here we provide two choices for \eqn{\tilde{\mu_{kj}}}. If \code{adapt.kms == TRUE}, \eqn{\tilde{\mu}_{kj}} is the estimates from the K-mean algorithm; otherwise, \eqn{\tilde{\mu}_{kj}} is the estimates from the model-based clustering without penalty.

The estimation uses the EM algorithm. Since the EM algorithm depends on the starting values. We use the estimates from K-means with multiple starting points as the starting values. For estimating the cluster means, APFP uses the local quadratic approximation.
}
\examples{
y <- rbind(matrix(rnorm(100,0,1),ncol=2), matrix(rnorm(100,4,1), ncol=2))
output <- apfp(K = c(1:2), lambda = c(0,1), y=y)
output$mu.hat.best

}
\references{
Guo, J., Levina, E., Michailidis, G., and Zhu, J. (2010) Pairwise variable selection for high-dimensional model-based clustering. \emph{Biometrics} \bold{66(3)}, 793--804.
}
\seealso{
\code{\link{nopenalty}} \code{\link{apL1}} \code{\link{parse}}
}
\keyword{external}

