% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cisim.R
\name{cisim}
\alias{cisim}
\title{Confidence Interval Simulation Program}
\usage{
cisim(samples = 100, n = 30, parameter = 0.5, sigma = 1,
  conf.level = 0.95, type = c("Mean", "Var", "Pi"))
}
\arguments{
\item{samples}{the number of samples desired.}

\item{n}{the size of each sample}

\item{parameter}{If constructing confidence intervals for the population mean or the population variance, parameter is the population mean (i.e., type is one of either \code{"Mean"} or \code{"Var"}). If constructing confidence intervals for the population proportion of successes, the value entered for parameter represents the population proportion of successes (\code{Pi}), and as such, must be a number between 0 and 1.}

\item{sigma}{is the population standard deviation. \code{sigma} is not required if confidence intervals are of type \code{"Pi"}.}

\item{conf.level}{confidence level for the graphed confidence intervals, restricted to lie between zero and one}

\item{type}{character string, one of \code{"Mean"}, \code{"Var"}, or \code{"Pi"}, or just the initial letter of each, indicating the type of confidence interval simulation to perform}
}
\value{
Performs specified simulation and draws the resulting confidence intervals on a graphical device.
}
\description{
This program simulates random samples from which it constructs confidence intervals for either the population mean, the population variance, or the population proportion of successes.
}
\details{
Default is to construct confidence intervals for the population mean. Simulated confidence intervals for the population variance or population proportion of successes are possible by selecting the appropriate value in the \code{type} argument.
}
\examples{
cisim(samples = 100, n = 30, parameter = 100, sigma = 10, conf.level = 0.90)
# Simulates 100 samples of size 30 from  a normal distribution with mean 100
# and a standard deviation of 10.  From the 100 simulated samples, 90\% confidence
# intervals for the Mean are constructed and depicted in the graph. 

cisim(100, 30, 100, 10, type = "Var")
# Simulates 100 sample of size 30 from a normal distribution with mean 100
# and a standard deviation of 10.  From the 100 simulated samples, 95\% confidence
# intervals for the variance are constructed and depicted in the graph.

cisim(100, 50, 0.5, type = "Pi", conf.level = 0.92)
# Simulates 100 samples of size 50 from a binomial distribution where the 
# population proportion of successes is 0.5.  From the 100 simulated samples,
# 92\% confidence intervals for Pi are constructed and depicted in the graph.
 
}
\author{
Alan T. Arnholt <arnholtat@appstate.edu>
}
\keyword{programming}

