# Functions for the prototype R package PBStry
# Adapted from counterparts in PBSmodelling

# ***********************************************************
# view:
#   View the first n rows of a data.frame or matrix
#   or first n elements of a vector or list.
#   All other objects are simply reflected.
# -----------------------------------------------------------
view <- function (obj, n = 5) {
  if (is.data.frame(obj) | is.matrix(obj)) 
    return(obj[1:min(nrow(obj), n), ])
  if (is.list(obj) | is.vector(obj)) 
    return(obj[1:min(length(obj), n)])
  return(obj) }
