% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMParam.R
\name{PCMParamCount}
\alias{PCMParamCount}
\title{Count the number of free parameters associated with a PCM or a PCM-parameter}
\usage{
PCMParamCount(o, countRegimeChanges = FALSE, countModelTypes = FALSE,
  offset = 0L, k = 1L, R = 1L, parentModel = NULL)
}
\arguments{
\item{o}{a PCM model object or a parameter of a PCM object}

\item{countRegimeChanges}{logical indicating if regime changes should be
counted. If TRUE, the default implementation would add
\code{PCMNumRegimes(model) - 1}. Default FALSE.}

\item{countModelTypes}{logical indicating whether the model type should be
counted. If TRUE the default implementation will add +1 only if there are
more than one modelTypes
(\code{length(attr(model, "modelTypes", exact = TRUE)) > 1}),
assuming that all regimes are regimes of the same model type (e.g. OU). The
implementation for MRG models will add +1 for every regime if there are more
than one modelTypes. Default FALSE.}

\item{offset}{an integer denoting an offset count from which to start counting
(internally used). Default: 0.}

\item{k}{an integer denoting the number of modeled traits. Default: 1.}

\item{R}{an integer denoting the number of regimes in the model. Default: 1.}

\item{parentModel}{NULL or a PCM object. Default: NULL.}
}
\value{
an integer
}
\description{
Count the number of free parameters associated with a PCM or a PCM-parameter
}
