% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{PCMPlotTraitData2D}
\alias{PCMPlotTraitData2D}
\title{Scatter plot of 2-dimensional data}
\usage{
PCMPlotTraitData2D(X, tree, labeledTips = NULL, sizeLabeledTips = 8,
  palette = PCMColorPalette(PCMNumRegimes(tree), PCMRegimes(tree)),
  scaleSizeWithTime = !is.ultrametric(tree))
}
\arguments{
\item{X}{a k x N matrix}

\item{tree}{a phylo object}

\item{labeledTips}{a vector of tip-numbers to label (NULL by default)}

\item{sizeLabeledTips}{passed geom_text to specify the size of tip-labels for the trait-points.}

\item{palette}{a named vector of colors}

\item{scaleSizeWithTime}{logical indicating if the size and the transparency of the points
should reflect the distance from the present (points that are farther away in time with
respect to the present moment, i.e. closer to the root of the tree, are displayed smaller
and more transparent.). By default this is set to \code{!is.ultrametric(tree)}.}
}
\value{
a ggplot object
}
\description{
Scatter plot of 2-dimensional data
}
