% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/full_enumerationc.R
\name{full_enumeration_pep}
\alias{full_enumeration_pep}
\title{Bayesian variable selection through exhaustive search}
\usage{
full_enumeration_pep(
  x,
  y,
  intrinsic = FALSE,
  reference.prior = TRUE,
  beta.binom = TRUE,
  ml_constant.term = FALSE
)
}
\arguments{
\item{x}{A matrix of numeric (of size nxp), input data matrix. 
This matrix contains the values of the p explanatory variables 
without an intercept column of 1's.}

\item{y}{A vector of numeric (of length n), response vector.}

\item{intrinsic}{Boolean, indicating whether the PEP 
(\code{FALSE}) or the intrinsic - which   
is a special case of it - (\code{TRUE}) should be used as prior on the  
regression parameters. Default value=\code{FALSE}.}

\item{reference.prior}{Boolean, indicating whether the reference prior
(\code{TRUE}) or the dependence Jeffreys prior (\code{FALSE}) is used as 
baseline. Default value=\code{TRUE}.}

\item{beta.binom}{Boolean, indicating whether the beta-binomial 
distribution (\code{TRUE}) or the uniform distribution (\code{FALSE})    
should be used as prior on the model space. Default value=\code{TRUE}.}

\item{ml_constant.term}{Boolean, indicating whether the constant
(marginal likelihood of the null/intercept-only model) should be
included in computing the marginal likelihood of a model (\code{TRUE})  
or not (\code{FALSE}). Default value=\code{FALSE}.}
}
\value{
\code{full_enumeration_pep} returns an object of class \code{pep}, 
i.e. a list with the following elements:
\item{models}{A matrix containing information about the models examined. 
In particular, in row i after representing the model i with variable inclusion 
indicators, its marginal likelihood (in log scale), the R2, its dimension  
(including the intercept), the corresponding Bayes factor, 
posterior odds and its posterior probability are contained. The models
are sorted in decreasing order of the posterior probability. For the 
Bayes factor and the posterior odds, the comparison is done to the model 
with the largest posterior probability.}
\item{inc.probs}{A named vector with the posterior inclusion probabilities of the 
explanatory variables.}
\item{x}{The input data matrix (of size nxp).}
\item{y}{The response vector (of length n).}
\item{intrinsic}{Whether the prior on the model parameters was PEP or intrinsic.}
\item{reference.prior}{Whether the baseline prior was the reference prior
or the dependence Jeffreys prior.}
\item{beta.binom}{Whether the prior on the model space was beta-binomial or
 uniform.}
}
\description{
Given a response vector and an input data matrix, performs Bayesian variable 
selection using full enumeration of the model space. Normal linear 
models are assumed for the data with the prior distribution on the model 
parameters (beta coefficients and error variance) being the PEP or the intrinsic. 
The prior distribution on the model space can be the uniform on the model 
space or the uniform on the model dimension (special case of the beta-binomial prior).
The model space consists of all possible models including an intercept term.
}
\details{
The function works when p<=n-2 where p is the number of explanatory variables
and n is the sample size.

It is suggested to use this function (i.e. enumeration of the model space) 
when p is up to 20.

The reference model is the null model (i.e. intercept-only model).

The case of missing data (i.e. presence of \code{NA}'s either in the  
input data matrix or the response vector) is not currently supported.

All models considered (i.e. model space) include an intercept term.

If p>1, the input data matrix needs to be of full rank.

The reference prior as baseline corresponds to hyperparameter values
d0=0 and d1=0, while the dependence Jeffreys prior corresponds to 
model-dependent-based values for the hyperparameters d0 and d1,
see Fouskakis and Ntzoufras (2022) for more details.

For computing the marginal likelihood of a model, Equation 16 of 
Fouskakis and Ntzoufras (2022) is used.

When \code{ml_constant.term=FALSE} then the log marginal likelihood of a
model in the output is shifted by -logC1
(logC1: log marginal likelihood of the null model).

When the prior on the model space is beta-binomial 
(i.e. \code{beta.binom=TRUE}), the following special case is used: uniform 
prior on model dimension.
}
\examples{
data(UScrime_data)
y <- UScrime_data[,"y"]
X <- UScrime_data[,-15]
res <- full_enumeration_pep(X,y)
resu <- full_enumeration_pep(X,y,beta.binom=FALSE)
resi <- full_enumeration_pep(X,y,intrinsic=TRUE)
resiu <- full_enumeration_pep(X,y,intrinsic=TRUE,beta.binom=FALSE)
resj <- full_enumeration_pep(X,y,reference.prior=FALSE)

}
\references{
Fouskakis, D. and Ntzoufras, I. (2022) Power-Expected-Posterior 
Priors as Mixtures of g-Priors in Normal Linear Models. 
Bayesian Analysis, 17(4): 1073-1099. \doi{10.1214/21-BA1288}
}
\seealso{
\code{\link{mc3_pep}}
}
