% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Optimization.R, R/FedorovWynnAlgorithm.R,
%   R/MultiplicativeAlgorithm.R, R/PGBOAlgorithm.R, R/SimplexAlgorithm.R
\name{Optimize}
\alias{Optimize}
\alias{Optimize,FedorovWynnAlgorithm-method}
\alias{Optimize,MultiplicativeAlgorithm-method}
\alias{Optimize,PGBOAlgorithm-method}
\alias{Optimize,SimplexAlgorithm-method}
\title{Set the optimization process.}
\usage{
Optimize(
  object,
  pfimProject,
  designs,
  statistical_model,
  cond_init,
  constraint,
  typeFim
)

\S4method{Optimize}{FedorovWynnAlgorithm}(object, statistical_model, cond_init, constraint, typeFim)

\S4method{Optimize}{MultiplicativeAlgorithm}(object, statistical_model, cond_init, constraint, typeFim)

\S4method{Optimize}{PGBOAlgorithm}(object, pfimProject, designs, statistical_model, constraint, typeFim)

\S4method{Optimize}{SimplexAlgorithm}(object, designs, statistical_model, constraint, typeFim)
}
\arguments{
\item{object}{An \code{Optimize} object.}

\item{pfimProject}{A \code{PFIMProject} object.}

\item{designs}{A \code{Design} object.}

\item{statistical_model}{A \code{StatisticalModel} object.}

\item{cond_init}{: A list of numeric giving the values of the initial conditions.}

\item{constraint}{A \code{Constraint} object.}

\item{typeFim}{A \code{FIM} object.}
}
\value{
A \code{design} object giving the optimal design.

The \code{FedorovWynnAlgorithm} object with:
\itemize{
\item \code{{OptimalDesign}:}{The optimal Design.}
\item \code{{optimalDoses}:}{A vector giving the optimal doses.}
\item \code{{FisherMatrix}:}{A matrix giving The Fisher Information Matrix.}
\item \code{{optimalFrequencies}:}{A vector of the optimal frequencies.}
\item \code{{optimalSamplingTimes}:}{A list of vectors of the optimal sampling times.}
}

The \code{MultiplicativeAlgorithm} object with:
\itemize{
\item \code{{OptimalDesign}:}{A \code{Design} object giving the optimal design.}
\item \code{{FinalWeights}:}{A list of the optimal weights.}
\item \code{{iteration_final }:}{A numeric of the final iteration of the process.}
\item \code{{allArms}:}{A list of all the arms in the optimal design.}
}

The \code{PGBOAlgorithm} object with:
\itemize{
\item \code{{resultsOptimization}:}{A dataframe giving the results for each iteration.}
\item \code{{OptimalDesign}:}{A  \code{Design} object giving the optimal design.}
\item \code{{iteration_fin }:}{A numeric of the final iteration of the process.}
}

A \code{Design} object giving the optimal design.
}
\description{
Set the optimization process.

Optimization with the Fedorov-Wynn algorithm.

Optimization with the Multiplicative Algorithm.

Optimization with the PGBO Algorithm.

Design optimization withe the Simplex algorithm.
}
