% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mortality.R
\name{mortality}
\alias{mortality}
\title{Calculating starvation related mortality of Thaumetopoea processionea}
\usage{
mortality(
  x,
  par_budswelling = "quercus_robur_type1",
  par_hatch = c("custers", "wagenhoff", "meurisse"),
  def_hatch = "first",
  last = TRUE
)
}
\arguments{
\item{x}{SpatRaster list (tmean, tmax, tmin) - numeric - with time attribute}

\item{par_budswelling}{character - parametrisation for bud swelling see parameter()}

\item{par_hatch}{character - parametrisation for hatch see parameter()}

\item{def_hatch}{definition of hatch - character - either "first" or "mean"}

\item{last}{If TRUE returns only the last day}
}
\value{
SpatRaster with mortality in \%.
}
\description{
Calculating starvation related mortality rate, dependent on degree days between the first hatch and feeding start (budswelling).
}
\examples{
\donttest{
srl <- load_test()
mortality(srl)
}
}
\seealso{
Other Main: 
\code{\link{get_legend}()},
\code{\link{parameter}()},
\code{\link{phenology}()},
\code{\link{phenthau}()}
}
\concept{Main}
