% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-PKNCAconc.R
\name{PKNCAconc}
\alias{PKNCAconc}
\alias{PKNCAconc.default}
\alias{PKNCAconc.tbl_df}
\alias{PKNCAconc.data.frame}
\title{Create a PKNCAconc object}
\usage{
PKNCAconc(data, ...)

\method{PKNCAconc}{default}(data, ...)

\method{PKNCAconc}{tbl_df}(data, ...)

\method{PKNCAconc}{data.frame}(
  data,
  formula,
  subject,
  time.nominal,
  exclude,
  duration,
  volume,
  exclude_half.life,
  include_half.life,
  sparse = FALSE,
  ...
)
}
\arguments{
\item{data}{A data frame with concentration (or amount for
urine/feces), time, and the groups defined in \code{formula}.}

\item{...}{Ignored.}

\item{formula}{The formula defining the
\code{concentration~time|groups} or \code{amount~time|groups} for
urine/feces (In the remainder of the documentation, "concentration" will be
used to describe concentration or amount.)  One special aspect of the
\code{groups} part of the formula is that the last group is typically
assumed to be the \code{subject}; see the documentation for the
\code{subject} argument for exceptions to this assumption.}

\item{subject}{The column indicating the subject number.  If not provided,
this defaults to the beginning of the inner groups: For example with
\code{concentration~time|Study+Subject/Analyte}, the inner groups start
with the first grouping variable before a \code{/}, \code{Subject}.  If
there is only one grouping variable, it is assumed to be the subject (e.g.
\code{concentration~time|Subject}), and if there are multiple grouping
variables without a \code{/}, subject is assumed to be the last one.  For
single-subject data, it is assigned as \code{NULL}.}

\item{time.nominal}{(optional) The name of the nominal time column
(if the main time variable is actual time.  The \code{time.nominal}
is not used during calculations; it is available to assist with
data summary and checking.}

\item{exclude}{(optional) The name of a column with concentrations to
exclude from calculations and summarization.  If given, the column
should have values of \code{NA} or \code{""} for concentrations to
include and non-empty text for concentrations to exclude.}

\item{duration}{(optional) The duration of collection as is typically
used for concentration measurements in urine or feces.}

\item{volume}{(optional) The volume (or mass) of collection as is
typically used for urine or feces measurements.}

\item{exclude_half.life, include_half.life}{A character scalar for the column
name in the dataset of the points to exclude from the half-life calculation
(still using normal curve-stripping selection rules for the other points)
or to include for the half-life (using specifically those points and
bypassing automatic curve-stripping point selection).  See the "Half-Life
Calculation" vignette for more details on the use of these arguments.}

\item{sparse}{Are the concentration-time data sparse PK (commonly used in
small nonclinical species or with terminal or difficult sampling) or dense
PK (commonly used in clinical studies or larger nonclinical species)?}
}
\value{
A PKNCAconc object that can be used for automated NCA.
}
\description{
Create a PKNCAconc object
}
\seealso{
Other PKNCA objects: 
\code{\link{PKNCAdata}()},
\code{\link{PKNCAdose}()},
\code{\link{PKNCAresults}()}
}
\concept{PKNCA objects}
