% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/half.life.R
\name{pk.calc.half.life}
\alias{pk.calc.half.life}
\title{Compute the half-life and associated parameters}
\usage{
pk.calc.half.life(conc, time, tmax, tlast, options = list(),
  min.hl.points = PKNCA.choose.option("min.hl.points", options),
  adj.r.squared.factor = PKNCA.choose.option("adj.r.squared.factor", options),
  conc.blq = PKNCA.choose.option("conc.blq", options),
  conc.na = PKNCA.choose.option("conc.na", options),
  first.tmax = PKNCA.choose.option("first.tmax", options),
  allow.tmax.in.half.life = PKNCA.choose.option("allow.tmax.in.half.life",
  options), check = TRUE)
}
\arguments{
\item{conc}{Concentration measured}

\item{time}{Time of concentration measurement}

\item{tmax}{Time of maximum concentration (will be calculated and
included in the return data frame if not given)}

\item{tlast}{Time of last concentration above the limit of
quantification (will be calculated and included in the return data
frame if not given)}

\item{options}{List of changes to the default
\code{\link{PKNCA.options}} for calculations.}

\item{min.hl.points}{The minimum number of points that must be
included to calculate the half-life}

\item{adj.r.squared.factor}{The allowance in adjusted r-squared for
adding another point.}

\item{conc.blq}{See \code{\link{clean.conc.blq}}}

\item{conc.na}{See \code{\link{clean.conc.na}}}

\item{first.tmax}{See \code{\link{pk.calc.tmax}}.}

\item{allow.tmax.in.half.life}{Allow the concentration point for
tmax to be included in the half-life slope calculation.}

\item{check}{Run \code{\link{check.conc.time}},
\code{\link{clean.conc.blq}}, and \code{\link{clean.conc.na}}?}
}
\value{
A data frame with one row and columns for
\describe{
  \item{tmax}{Time of maximum observed concentration (only included if not given as an input)}
  \item{tlast}{Time of last observed concentration above the LOQ (only included if not given as an input)}
  \item{r.squared}{coefficient of determination}
  \item{adj.r.squared}{adjusted coefficient of determination}
  \item{lambda.z}{elimination rate}
  \item{lambda.z.time.first}{first time for half-life calculation}
  \item{lambda.z.n.points}{number of points in half-life calculation}
  \item{clast.pred}{Concentration at tlast as predicted by the half-life
      line}
  \item{half.life}{half-life}
  \item{span.ratio}{span ratio [ratio of half-life to time used for half-life
      calculation}
}
}
\description{
The half-life is calculated by computing the best fit line for all
available sets of points.  The best one is chosen by the following
rules in order:
}
\details{
\itemize{
\item{At least \code{min.hl.points} points included}
\item{A \code{lambda.z} > 0}
\item{The best adjusted r-squared (within \code{adj.r.squared.factor})}
\item{The one with the most points included}
}
}
\references{
Gabrielsson J, Weiner D.  "Section 2.8.4 Strategies for estimation
of lambda-z."  Pharmacokinetic & Pharmacodynamic Data Analysis:
Concepts and Applications, 4th Edition.  Stockholm, Sweden: Swedish
Pharmaceutical Press, 2000.  167-9.
}

