% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exclude_nca.R
\name{exclude_nca}
\alias{exclude_nca}
\alias{exclude_nca_span.ratio}
\alias{exclude_nca_max.aucinf.pext}
\alias{exclude_nca_min.hl.r.squared}
\title{Exclude NCA parameters based on examining the parameter set.}
\usage{
exclude_nca_span.ratio(min.span.ratio)

exclude_nca_max.aucinf.pext(max.aucinf.pext)

exclude_nca_min.hl.r.squared(min.hl.r.squared)
}
\arguments{
\item{min.span.ratio}{The minimum acceptable span ratio (uses 
\code{PKNCA.options("min.span.ratio")} if not provided).}

\item{max.aucinf.pext}{The maximum acceptable percent AUC
extrapolation (uses \code{PKNCA.options("max.aucinf.pext")} if not
provided).}

\item{min.hl.r.squared}{The minimum acceptable r-squared value for
half-life (uses \code{PKNCA.options("min.hl.r.squared")} if not
provided).}
}
\description{
Exclude NCA parameters based on examining the parameter set.
}
\section{Functions}{
\itemize{
\item \code{exclude_nca_span.ratio}: Exclude based on span.ratio

\item \code{exclude_nca_max.aucinf.pext}: Exclude based on AUC percent extrapolated
(both observed and predicted)

\item \code{exclude_nca_min.hl.r.squared}: Exclude based on half-life r-squared
}}

\examples{
my_conc <- PKNCAconc(data.frame(conc=1.1^(3:0),
                                time=0:3,
                                subject=1),
                     conc~time|subject)
my_data <- PKNCAdata(my_conc,
                     intervals=data.frame(start=0, end=Inf,
                                          aucinf.obs=TRUE,
                                          aucpext.obs=TRUE))
my_result <- pk.nca(my_data)
my_result_excluded <- exclude(my_result,
                              FUN=exclude_nca_max.aucinf.pext())
as.data.frame(my_result_excluded)
}
