% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_var_y.R
\name{get_var_y}
\alias{get_var_y}
\title{Get expected variance/sd/ci of dependent variable
based on PKPDsim model, parameters, and regimen}
\usage{
get_var_y(
  model = NULL,
  parameters = list(),
  regimen = list(),
  t_obs = c(1:48),
  obs_comp = NULL,
  obs_variable = NULL,
  omega = c(0.1, 0.05, 0.1),
  omega_full = NULL,
  n_ind = NULL,
  ruv = NULL,
  y = NULL,
  rel_delta = 1e-04,
  method = "delta",
  sequence = NULL,
  auc = FALSE,
  sd = TRUE,
  q = NULL,
  in_parallel = FALSE,
  n_cores = 3,
  return_all = FALSE,
  ...
)
}
\arguments{
\item{model}{model, created using `PKPDsim::new_ode_model()`}

\item{parameters}{parameters list}

\item{regimen}{regimen, as created using `PKPDsim::new_regimen()`}

\item{t_obs}{vector of observation times}

\item{obs_comp}{observation compartment. If NULL will be "obs" (default)}

\item{obs_variable}{observation variable. If NULL, will be ignored, otherwise will override `obs_comp`.}

\item{omega}{triangle omega block}

\item{omega_full}{full omega block}

\item{n_ind}{number of individuals to simulate with sim method}

\item{ruv}{residual variability, supplied as a named list, ex: `list(prop = 0, add = 0, exp = 0)`}

\item{y}{vector of observations. If NULL, then a new simulation will be performed.}

\item{rel_delta}{rel_delta}

\item{method}{method, `delta` or `sim`}

\item{sequence}{for simulations, if not NULL the pseudo-random sequence to use, e.g. "halton" or "sobol". See `mvrnorm2` for more details.}

\item{auc}{is AUC?}

\item{sd}{return as standard deviation (`TRUE`) or variance (`FALSE`)}

\item{q}{return vector of quantiles instead of sd/var. Will return parametric quantiles when delta-method is used, non-parametric for simulation-based methods.}

\item{in_parallel}{run simulations in parallel?}

\item{n_cores}{if run in parallel, on how many cores?}

\item{return_all}{return object with all relevant information?}

\item{...}{passed on to `sim_ode()`}
}
\value{
Vector of standard deviations or variances (or quantiles thereof) for dependent value
  variable
}
\description{
Get expected variance/sd/ci of dependent variable
based on PKPDsim model, parameters, and regimen
}
