% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R
\name{rank_ord_switch}
\alias{rank_ord_switch}
\title{Switch from orderings to rankings and vice versa}
\usage{
rank_ord_switch(data, format_input, nranked = NULL)
}
\arguments{
\item{data}{Numeric \eqn{N}\eqn{\times}{x}\eqn{K} data matrix of partial sequences whose format has to be converted.}

\item{format_input}{Character string indicating the format of the \code{data} input, namely \code{"ordering"} or \code{"ranking"}.}

\item{nranked}{Optional numeric vector of length \eqn{N} with the number of items ranked by each sample unit.}
}
\value{
Numeric \eqn{N}\eqn{\times}{x}\eqn{K} data matrix of partial sequences with inverse format.
}
\description{
Convert the format of the input dataset from orderings to rankings and vice versa.
}
\examples{

## From orderings to rankings for the Dublin West dataset
data(d_dublinwest)
head(d_dublinwest)
rank_ord_switch(data=head(d_dublinwest), format_input="ordering")
}
\author{
Cristina Mollica and Luca Tardella
}
