% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNnetworkfamily-class.R
\name{PLNnetworkfamily}
\alias{PLNnetworkfamily}
\title{An R6 Class to represent a collection of PLNnetworkfit}
\description{
The function \code{\link[=PLNnetwork]{PLNnetwork()}} produces an instance of this class.

This class comes with a set of methods, some of them being useful for the user:
See the documentation for \code{\link[=getBestModel]{getBestModel()}},
\code{\link[=getModel]{getModel()}} and \link[=plot.PLNnetworkfamily]{plot()}
}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
fits <- PLNnetwork(Abundance ~ 1, data = trichoptera)
class(fits)
}
\seealso{
The function \code{\link[=PLNnetwork]{PLNnetwork()}}, the class \code{\link{PLNnetworkfit}}
}
\section{Super class}{
\code{\link[PLNmodels:PLNfamily]{PLNmodels::PLNfamily}} -> \code{PLNnetworkfamily}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{penalties}}{the sparsity level of the network in the successively fitted models}

\item{\code{stability_path}}{the stability path of each edge as returned by the stars procedure}

\item{\code{stability}}{mean edge stability along the penalty path}

\item{\code{criteria}}{a data frame with the values of some criteria (approximated log-likelihood, (E)BIC, ICL and R2, stability) for the collection of models / fits
BIC, ICL and EBIC are defined so that they are on the same scale as the model log-likelihood, i.e. with the form, loglik - 0.5 penalty}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PLNnetworkfamily$new()}}
\item \href{#method-optimize}{\code{PLNnetworkfamily$optimize()}}
\item \href{#method-stability_selection}{\code{PLNnetworkfamily$stability_selection()}}
\item \href{#method-coefficient_path}{\code{PLNnetworkfamily$coefficient_path()}}
\item \href{#method-getBestModel}{\code{PLNnetworkfamily$getBestModel()}}
\item \href{#method-plot}{\code{PLNnetworkfamily$plot()}}
\item \href{#method-plot_stars}{\code{PLNnetworkfamily$plot_stars()}}
\item \href{#method-plot_objective}{\code{PLNnetworkfamily$plot_objective()}}
\item \href{#method-show}{\code{PLNnetworkfamily$show()}}
\item \href{#method-clone}{\code{PLNnetworkfamily$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfamily" data-id="getModel">}\href{../../PLNmodels/html/PLNfamily.html#method-getModel}{\code{PLNmodels::PLNfamily$getModel()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfamily" data-id="postTreatment">}\href{../../PLNmodels/html/PLNfamily.html#method-postTreatment}{\code{PLNmodels::PLNfamily$postTreatment()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfamily" data-id="print">}\href{../../PLNmodels/html/PLNfamily.html#method-print}{\code{PLNmodels::PLNfamily$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize all models in the collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNnetworkfamily$new(
  penalties,
  responses,
  covariates,
  offsets,
  weights,
  formula,
  xlevels,
  control
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{penalties}}{a vector of positive real number controlling the level of sparsity of the underlying network.}

\item{\code{responses}}{the matrix of responses common to every models}

\item{\code{covariates}}{the matrix of covariates common to every models}

\item{\code{offsets}}{the matrix of offsets common to every models}

\item{\code{weights}}{the vector of observation weights}

\item{\code{formula}}{model formula used for fitting, extracted from the formula in the upper-level call}

\item{\code{xlevels}}{named listed of factor levels included in the models, extracted from the formula in the upper-level call and used for predictions.}

\item{\code{control}}{a list for controlling the optimization. See details.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Update current \code{\link{PLNnetworkfit}} with smart starting values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-optimize}{}}}
\subsection{Method \code{optimize()}}{
Call to the C++ optimizer on all models of the collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNnetworkfamily$optimize(control)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{control}}{a list for controlling the optimization. See details.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-stability_selection"></a>}}
\if{latex}{\out{\hypertarget{method-stability_selection}{}}}
\subsection{Method \code{stability_selection()}}{
Compute the stability path by stability selection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNnetworkfamily$stability_selection(subsamples = NULL, control = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{subsamples}}{a list of vectors describing the subsamples. The number of vectors (or list length) determines the number of subsamples used in the stability selection. Automatically set to 20 subsamples with size \code{10*sqrt(n)} if \code{n >= 144} and \code{0.8*n} otherwise following Liu et al. (2010) recommendations.}

\item{\code{control}}{a list controlling the main optimization process in each call to PLNnetwork. See \code{\link[=PLNnetwork]{PLNnetwork()}} for details.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-coefficient_path"></a>}}
\if{latex}{\out{\hypertarget{method-coefficient_path}{}}}
\subsection{Method \code{coefficient_path()}}{
Extract the regularization path of a \code{\link{PLNnetworkfamily}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNnetworkfamily$coefficient_path(precision = TRUE, corr = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{precision}}{Logical. Should the regularization path be extracted from the precision matrix Omega (\code{TRUE}, default) or from the variance matrix Sigma (\code{FALSE})}

\item{\code{corr}}{Logical. Should the matrix be transformed to (partial) correlation matrix before extraction? Defaults to \code{TRUE}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getBestModel"></a>}}
\if{latex}{\out{\hypertarget{method-getBestModel}{}}}
\subsection{Method \code{getBestModel()}}{
Extract the best network in the family according to some criteria
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNnetworkfamily$getBestModel(
  crit = c("BIC", "EBIC", "StARS"),
  stability = 0.9
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{crit}}{character. Criterion used to perform the selection. Is "StARS" is chosen but \verb{$stability} field is empty, will compute stability path.}

\item{\code{stability}}{Only used for "StARS" criterion. A scalar indicating the target stability (= 1 - 2 beta) at which the network is selected. Default is \code{0.9}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot"></a>}}
\if{latex}{\out{\hypertarget{method-plot}{}}}
\subsection{Method \code{plot()}}{
Display various outputs (goodness-of-fit criteria, robustness, diagnostic) associated with a collection of PLNnetwork fits (a \code{\link{PLNnetworkfamily}})
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNnetworkfamily$plot(
  criteria = c("loglik", "pen_loglik", "BIC", "EBIC"),
  reverse = FALSE,
  log.x = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{criteria}}{vector of characters. The criteria to plot in \code{c("loglik", "pen_loglik", "BIC", "EBIC")}. Defaults to all of them.}

\item{\code{reverse}}{A logical indicating whether to plot the value of the criteria in the "natural" direction
(loglik - 0.5 penalty) or in the "reverse" direction (-2 loglik + penalty). Default to FALSE, i.e use the
natural direction, on the same scale as the log-likelihood..}

\item{\code{log.x}}{logical: should the x-axis be represented in log-scale? Default is \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a \code{\link{ggplot}} graph
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_stars"></a>}}
\if{latex}{\out{\hypertarget{method-plot_stars}{}}}
\subsection{Method \code{plot_stars()}}{
Plot stability path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNnetworkfamily$plot_stars(stability = 0.9, log.x = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{stability}}{scalar: the targeted level of stability in stability plot. Default is \code{0.9}.}

\item{\code{log.x}}{logical: should the x-axis be represented in log-scale? Default is \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a \code{\link{ggplot}} graph
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_objective"></a>}}
\if{latex}{\out{\hypertarget{method-plot_objective}{}}}
\subsection{Method \code{plot_objective()}}{
Plot objective value of the optimization problem along the penalty path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNnetworkfamily$plot_objective()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a \code{\link{ggplot}} graph
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show"></a>}}
\if{latex}{\out{\hypertarget{method-show}{}}}
\subsection{Method \code{show()}}{
User friendly print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNnetworkfamily$show()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNnetworkfamily$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
