% Generated by roxygen2 (4.0.1): do not edit by hand
\name{SPLS.GLM}
\alias{SPLS.GLM}
\title{Sparse Partial Least Squares-Generalized Linear Model (SPLS-GLM) algorithm}
\usage{
SPLS.GLM(X, y, A, lambdaY, lambdaX, eps = 0.001, ...)
}
\arguments{
\item{X}{A (NxP) predictor matrix}

\item{y}{A (Nx1) Poisson-distributed response vector}

\item{A}{The number of PLS components}

\item{lambdaY}{A value for the penalty parameters for the soft-thresholding penalization function for Y-weights}

\item{lambdaX}{A value for the penalty parameters for the soft-thresholding penalization function for X-weights}

\item{eps}{Cut off value for convergence step}

\item{...}{Other arguments. Currently ignored}
}
\value{
The SPLS-GLM parameters of D=[X y]
}
\description{
Takes in a set of predictor variables and a set of response variables and gives the SPLS-GLM parameters.
}
\examples{
if(require(robustbase))
possum.mat
y = as.matrix(possum.mat[,1], ncol=1)
dimnames(y) = list(paste("S", 1:nrow(possum.mat), seq=""), "Diversity")
X = as.matrix(possum.mat[,2:14], ncol=13)
dimnames(X) = list(paste("S", 1:nrow(possum.mat), seq=""), colnames(possum.mat[,2:14]))
SPLS.GLM(scale(X), scale(y), A=2, lambdaY=0, lambdaX=3.3, eps=1e-3)
#lambdaX and lambdaY value are determined using function opt.penalty.values
#for more details, see opt.penalty.values help file
}
\author{
Opeoluwa F. Oyedele and Sugnet Gardner-Lubbe
}

