% Generated by roxygen2 (4.0.1): do not edit by hand
\name{mod.KernelPLS_R}
\alias{mod.KernelPLS_R}
\title{The Kernel algorithm for few(er) samples but large variables by Rannar et al. (1994)}
\usage{
mod.KernelPLS_R(X, Y, A, ...)
}
\arguments{
\item{X}{A (NxP) predictor matrix}

\item{Y}{A (NxM) response matrix}

\item{A}{The number of PLS components}

\item{...}{Other arguments. Currently ignored}
}
\value{
The PLS parameters using the Kernel algorithm by RC$nnar et al. (1994)
}
\description{
Takes in a set of predictor variables and a set of response variables and gives the Partial Least Squares (PLS) parameters.
}
\examples{
if(require(pls))
data(oliveoil, package="pls")
X = as.matrix(oliveoil$chemical, ncol=5)
dimnames(X) = list(paste(c("G1","G2","G3","G4","G5","I1","I2","I3","I4","I5",
"S1","S2","S3","S4","S5","S6")),
paste(c("Acidity","Peroxide","K232","K270","DK")))
Y = as.matrix(oliveoil$sensory, ncol=6)
dimnames(Y) = list(paste(c("G1","G2","G3","G4","G5","I1","I2","I3","I4","I5",
"S1","S2","S3","S4","S5","S6")),
paste(c("Yellow","Green","Brown","Glossy","Transp","Syrup")))
mod.KernelPLS_R(X, Y, A=5)
}
\author{
Opeoluwa F. Oyedele and Sugnet Gardner-Lubbe
}

