% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.r
\name{predict.pls}
\alias{predict.pls}
\title{Predict according to the Estimated Parameters}
\usage{
\method{predict}{pls}(object, x_test = NULL, z_test, ...)
}
\arguments{
\item{object}{fitted partially linear single-index model, which could be obtained by}

\item{x_test}{input matrix (linear covariates of test set).}

\item{z_test}{input matrix (nonlinear covariates of test set).}

\item{\dots}{additional arguments.

\link{plsim.MAVE}, or \link{plsim.est}, or \link{plsim.vs.soft}.}
}
\value{
\item{y_hat}{prediction.}
}
\description{
Predict Y based on new observations.
}
\examples{

n = 50
sigma = 0.1

alpha = matrix(1, 2, 1)
alpha = alpha/norm(alpha, "2")

beta = matrix(4, 1, 1)

x = matrix(1, n, 1)
x_test = matrix(1,n,1)

z = matrix(runif(n*2), n, 2)
z_test = matrix(runif(n*2), n, 2)

y = 4*((z\%*\%alpha-1/sqrt(2))^2) + x\%*\%beta + sigma*matrix(rnorm(n),n,1)
y_test = 4*((z_test\%*\%alpha-1/sqrt(2))^2) + x_test\%*\%beta + sigma*matrix(rnorm(n),n,1)


# Obtain parameters in PLSiM using Profile Least Squares Estimator
fit_plsimest = plsim.est(x, z, y)

preds_plsimest = predict(fit_plsimest, x_test, z_test)

# Print the MSE of the Profile Least Squares Estimator method
print( sum( (preds_plsimest-y_test)^2)/nrow(y_test) )

# Obtain parameters in PLSiM using Penalized Profile Least Squares Estimator
fit_plsim = plsim.vs.soft(x, z, y,lambda = 0.01)

preds_plsim = predict(fit_plsim, x_test, z_test)

# Print the MSE of the Penalized Profile Least Squares Estimator method
print( sum( (preds_plsim-y_test)^2)/nrow(y_test) )

}
