#' Firm Cost
#'
#' A dataset on risk management practices of 73 firms.
#'
#' @usage data(Firm)
#' @format A data frame with 73 rows and 7 variables:
#' \describe{
#'   \item{firmcost}{total property and casualty premiums and uninsured losses
#'      as a percentage of total assets.}
#'   \item{assume}{per occurrence retention amount as a percentage of total
#'      assets.}
#'   \item{cap}{indicates that the firm owns a captive insurance company; 1 if
#'      the firm uses a captive, 0 otherwise.}
#'   \item{sizelog}{logarithm of total assets.}
#'   \item{indcost}{a measure of the firm's industry risk.}
#'   \item{central}{a measure of the importance of the local managers in
#'      choosing the amount of risk to be retained.}
#'   \item{soph}{a measure of the degree of importance in using analytical tools.}
#' }
#' @details The dataset was introduced and analyzed by Schmit and Roth (1990) and
#'     is available in the personal web page of Professor E. Frees (Wisconsin School
#'      of Business Research). The response variable is \code{FIRMCOST}, smaller
#'      values of firm cost are attributed to firms that have a good risk management
#'      performance.
#' @keywords datasets
#' @source \url{https://instruction.bus.wisc.edu/jfrees/jfreesbooks/Regression%20Modeling/BookWebDec2010/CSVData/RiskSurvey.csv}
#' @references Schmit, J.T. and Roth, K. (1990). Cost effectiveness of risk management
#'     practices. \emph{Journal of Risk and Insurance}. 57:455-470.
#' @examples data("Firm")
#' fitPL <- PLreg(firmcost ~ sizelog + indcost | sizelog + indcost,
#'               data = Firm,
#'               family = "SLASH",
#'               zeta = 2.13)
#'summary(fitPL)
#'plot(fitPL, type = "standardized")
"Firm"
