% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLreg.R
\name{methodsPLreg}
\alias{methodsPLreg}
\alias{summary.PLreg}
\alias{print.PLreg}
\alias{print.summary.PLreg}
\alias{coef.PLreg}
\alias{vcov.PLreg}
\alias{logLik.PLreg}
\alias{model.matrix.PLreg}
\title{Methods for PLreg Objects}
\usage{
\method{summary}{PLreg}(object, type = "standardized", ...)

\method{print}{PLreg}(x, ...)

\method{print}{summary.PLreg}(x, ...)

\method{coef}{PLreg}(object, ...)

\method{vcov}{PLreg}(object, ...)

\method{logLik}{PLreg}(object, ...)

\method{model.matrix}{PLreg}(object, model = c("median", "dispersion"), ...)
}
\arguments{
\item{object, x}{fitted model object of class "\code{PLreg}".}

\item{type}{character specifying the type of residuals to be included in the
summary output, see \code{\link{residuals.PLreg}}.}

\item{...}{currently not used.}

\item{model}{character specifying for which component of the model the
coefficients/covariance are extracted.}
}
\description{
Some S3 Methods for PLreg regression models.
}
\details{
A set of methods for objects of class "\code{PLreg}", including methods
for the functions \code{\link{summary}} and \code{\link{vcov}},
which print the estimated coefficients along with some other information and
presents the covariance matrix, respectively. The \code{summary} also presents
the partial Wald tests for the model parameters. Finally, \code{summary} returns
an object of class "\code{summary.PLreg}" containing information to be printed
using the \code{print} method.
}
\examples{
data("bodyfat_Aeolus")

fitPL <- PLreg(percentfat ~ 1, data = bodyfat_Aeolus,
              family = "SN", zeta = 1.6)
fitPL
summary(fitPL)
coef(fitPL, model = "median")
vcov(fitPL)
logLik(fitPL)
AIC(fitPL)
}
\seealso{
\code{\link{PLreg}}
}
