% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.PMCMR.R
\name{plot.PMCMR}
\alias{plot.PMCMR}
\title{Plotting PMCMR Objects}
\usage{
\method{plot}{PMCMR}(x, alpha = 0.05, ...)
}
\arguments{
\item{x}{an object of class \code{"PMCMR"}.}

\item{alpha}{the selected alpha-level. Defaults to 0.05.}

\item{\dots}{further arguments for method \code{boxplot}.}
}
\value{
A box-whisker plot for each factor level. The range of the whiskers indicate
the extremes (\code{boxplot = x, ..., range=0}). Letter symbols are depicted on top of each box.
Different letters indicate significant
differences between groups on the selected level of alpha.
}
\description{
Plotting method for objects inheriting from class \code{"PMCMR"}.
}
\examples{
## data set InsectSprays
ans <- kwAllPairsNemenyiTest(count ~ spray, data = InsectSprays)
plot(ans)
plot(ans, col="red",main="My title", xlab="Spray", "Count")
}
\seealso{
\code{\link{boxplot}}
}
\keyword{plot}
