% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bwsKSampleTest.R
\name{bwsKSampleTest}
\alias{bwsKSampleTest}
\alias{bwsKSampleTest.default}
\alias{bwsKSampleTest.formula}
\title{Murakami's k-Sample BWS Test}
\usage{
bwsKSampleTest(x, ...)

\method{bwsKSampleTest}{default}(x, g, nperm = 1000, ...)

\method{bwsKSampleTest}{formula}(formula, data, subset, na.action,
  nperm = 1000, ...)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{nperm}{number of permutations for the assymptotic permutation test.
Defaults to \code{1000}.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"htest"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{the estimated quantile of the test statistic.}
 \item{p.value}{the p-value for the test.}
 \item{parameter}{the parameters of the test statistic, if any.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{estimates}{the estimates, if any.}
\item{null.value}{the estimate under the null hypothesis, if any.}
}
}
\description{
Performs Murakami's k-Sample BWS Test.
}
\details{
The null hypothesis, H\eqn{_0: F_1 = F_2 = \ldots = F_k}
is tested against the alternative,
H\eqn{_\mathrm{A}: F_i \ne F_j ~~(i \ne j)}, with at least
one unequality beeing strict.

The p-values are estimated through an assymptotic boot-strap method.
}
\note{
One may increase the number of permutations to e.g. \code{nperm = 10000}
in order to get more precise p-values. However, this will be on
the expense of computational time.
}
\examples{
#' ## Hollander & Wolfe (1973), 116.
## Mucociliary efficiency from the rate of removal of dust in normal
## subjects, subjects with obstructive airway disease, and subjects
## with asbestosis.
x <- c(2.9, 3.0, 2.5, 2.6, 3.2) # normal subjects
y <- c(3.8, 2.7, 4.0, 2.4)      # with obstructive airway disease
z <- c(2.8, 3.4, 3.7, 2.2, 2.0) # with asbestosis

datf <- data.frame(
  g = g <- c(rep("ns", length(x)), rep("oad",
      length(y)), rep("a", length(z))),
  x = x <- c(x, y, z))

## k-sample BWS Test
bwsKSampleTest(x ~ g, datf)

}
\references{
Baumgartner, W., Weiss, P., Schindler, H. (1998) A nonparametric test for the
general two-sample problem, \emph{Biometrics} \bold{54}, 1129--1135.

Murakami, H. (2006) K-sample rank test based on modified Baumgartner statistic and its power
comparison, \emph{J. Jpn. Comp. Statist.} \bold{19}, 1--13.
}
\seealso{
\code{\link{sample}}, \code{\link{bwsAllPairsTest}},
\code{\link{bwsManyOneTest}}.
}
\keyword{htest}
\keyword{nonparametric}
