% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kwManyOneConoverTest.R
\name{kwManyOneConoverTest}
\alias{kwManyOneConoverTest}
\alias{kwManyOneConoverTest.default}
\alias{kwManyOneConoverTest.formula}
\title{Conover's Many-to-One Rank Comparison Test}
\usage{
kwManyOneConoverTest(x, ...)

\method{kwManyOneConoverTest}{default}(
  x,
  g,
  alternative = c("two.sided", "greater", "less"),
  p.adjust.method = c("single-step", p.adjust.methods),
  ...
)

\method{kwManyOneConoverTest}{formula}(
  formula,
  data,
  subset,
  na.action,
  alternative = c("two.sided", "greater", "less"),
  p.adjust.method = c("single-step", p.adjust.methods),
  ...
)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{alternative}{the alternative hypothesis. Defaults to \code{two.sided}.}

\item{p.adjust.method}{method for adjusting p values
(see \code{\link{p.adjust}}).}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
 \item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs Conover's non-parametric many-to-one comparison
test for Kruskal-type ranked data.
}
\details{
For many-to-one comparisons (pairwise comparisons with one control)
in an one-factorial layout with non-normally distributed
residuals Conover's non-parametric test can be performed.
Let there be \eqn{k} groups including the control,
then the number of treatment levels is \eqn{m = k - 1}.
Then \eqn{m} pairwise comparisons can be performed between
the \eqn{i}-th treatment level and the control.
H\eqn{_i: \theta_0 = \theta_i} is tested in the two-tailed case against
A\eqn{_i: \theta_0 \ne \theta_i, ~~ (1 \le i \le m)}.

If \code{p.adjust.method == "single-step"} is selected,
the \eqn{p}-values will be computed
from the multivariate \eqn{t} distribution. Otherwise,
the \eqn{p}-values are computed from the \eqn{t}-distribution using
any of the \eqn{p}-adjustment methods as included in \code{\link{p.adjust}}.
}
\examples{
## Data set PlantGrowth
## Global test
kruskalTest(weight ~ group, data = PlantGrowth)

## Conover's many-one comparison test
## single-step means p-value from multivariate t distribution
ans <- kwManyOneConoverTest(weight ~ group, data = PlantGrowth,
                             p.adjust.method = "single-step")
summary(ans)

## Conover's many-one comparison test
ans <- kwManyOneConoverTest(weight ~ group, data = PlantGrowth,
                             p.adjust.method = "holm")
summary(ans)

## Dunn's many-one comparison test
ans <- kwManyOneDunnTest(weight ~ group, data = PlantGrowth,
                             p.adjust.method = "holm")
summary(ans)

## Nemenyi's many-one comparison test
ans <- kwManyOneNdwTest(weight ~ group, data = PlantGrowth,
                        p.adjust.method = "holm")
summary(ans)
}
\references{
Conover, W. J, Iman,  R. L. (1979) \emph{On multiple-comparisons
 procedures}, Tech. Rep. LA-7677-MS, Los Alamos Scientific Laboratory.
}
\seealso{
\code{\link{pmvt}}, \code{\link{TDist}}, \code{\link{kruskalTest}},
\code{\link{kwManyOneDunnTest}}, \code{\link{kwManyOneNdwTest}}
}
\concept{kruskalranks}
\keyword{htest}
\keyword{nonparametric}
