% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsAllPairsTest.R
\name{hsAllPairsTest}
\alias{hsAllPairsTest}
\alias{hsAllPairsTest.default}
\alias{hsAllPairsTest.formula}
\title{Hayter-Stone All-Pairs Comparison Test}
\source{
If \code{method = "asympt"} is selected, this function calls
an internal probability function \code{pHS}. The GPL-2 code for
this function was taken from \code{pHayStonLSA} of the
the package \pkg{NSM3}:

Grant Schneider, Eric Chicken and Rachel Becvarik (2020) NSM3:
Functions and Datasets to Accompany Hollander, Wolfe, and
Chicken - Nonparametric Statistical Methods, Third Edition. R
package version 1.15. \url{https://CRAN.R-project.org/package=NSM3}
}
\usage{
hsAllPairsTest(x, ...)

\method{hsAllPairsTest}{default}(
  x,
  g,
  alternative = c("greater", "less"),
  method = c("look-up", "boot", "asympt"),
  nperm = 10000,
  ...
)

\method{hsAllPairsTest}{formula}(
  formula,
  data,
  subset,
  na.action,
  alternative = c("greater", "less"),
  method = c("look-up", "boot", "asympt"),
  nperm = 10000,
  ...
)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{alternative}{the alternative hypothesis. Defaults to \code{greater}.}

\item{method}{a character string specifying the test statistic to use.
Defaults to \code{"look-up"} that uses published Table values of Williams (1972).}

\item{nperm}{number of permutations for the asymptotic permutation test.
Defaults to \code{1000}. Ignored, if \code{method = "look-up"}.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
Either a list of class \code{"PMCMR"} or a
list with class \code{"osrt"} that contains the following
components:

\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{the estimated statistic(s)}
 \item{crit.value}{critical values for \eqn{\alpha = 0.05}.}
 \item{alternative}{a character string describing the alternative hypothesis.}
 \item{parameter}{the parameter(s) of the test distribution.}
\item{dist}{a string that denotes the test distribution.}
}
There are print and summary methods available.

A list with class \code{"PMCMR"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
 \item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs the non-parametric Hayter-Stone all-pairs procedure
to test against monotonically increasing alternatives.
}
\details{
Let \eqn{X} be an identically and idepentendly distributed variable
that was \eqn{n} times observed at \eqn{k} increasing treatment levels.
Hayter and Stone (1991) proposed a non-parametric procedure
to test the null hypothesis, H: \eqn{\theta_i = \theta_j ~~ (i < j \le k)}
against a simple order alternative, A: \eqn{\theta_i < \theta_j}.

The statistic for all-pairs comparisons is calculated as,
\deqn{
 S_{ij} = \frac{2 \sqrt{6} \left(U_{ij} - n_i n_j / 2 \right)}
 {\sqrt{n_i n_j \left(n_i + n_j + 1 \right)}},
}{%
SEE PDF.
}

with the Mann-Whittney counts:
\deqn{
U_{ij} =  \sum_{a=1}^{n_i} \sum_{b=1}^{n_j} I\left\{x_{ia} < x_{ja}\right\}.
}{%
SEE PDF
}

Under the large sample approximation, the test statistic \eqn{S_{ij}} is distributed
as \eqn{h_{k,\alpha,v}}. Thus, the null hypothesis is rejected,
if \eqn{S_{ij} > h_{k,\alpha,v}}, with \eqn{v = \infty} degree of freedom.

If \code{method = "look-up"} the function will not return
p-values. Instead the critical h-values
as given in the tables of Hayter (1990) for
\eqn{\alpha = 0.05} (one-sided)
are looked up according to the number of groups (\eqn{k}) and
the degree of freedoms (\eqn{v = \infty}).

If \code{method = "boot"} an asymetric permutation test
is conducted and \eqn{p}-values are returned.

 If \code{method = "asympt"} is selected the asymptotic
\eqn{p}-value is estimated as implemented in the
function \code{pHayStonLSA} of the package \pkg{NSM3}.
}
\examples{
## Example from Shirley (1977)
## Reaction times of mice to stimuli to their tails.
x <- c(2.4, 3, 3, 2.2, 2.2, 2.2, 2.2, 2.8, 2, 3,
 2.8, 2.2, 3.8, 9.4, 8.4, 3, 3.2, 4.4, 3.2, 7.4, 9.8, 3.2, 5.8,
 7.8, 2.6, 2.2, 6.2, 9.4, 7.8, 3.4, 7, 9.8, 9.4, 8.8, 8.8, 3.4,
 9, 8.4, 2.4, 7.8)
g <- gl(4, 10)

## Shirley's test
## one-sided test using look-up table
shirleyWilliamsTest(x ~ g, alternative = "greater")

## Chacko's global hypothesis test for 'greater'
chackoTest(x , g)

## post-hoc test, default is standard normal distribution (NPT'-test)
summary(chaAllPairsNashimotoTest(x, g, p.adjust.method = "none"))

## same but h-distribution (NPY'-test)
chaAllPairsNashimotoTest(x, g, dist = "h")

## NPM-test
NPMTest(x, g)

## Hayter-Stone test
hayterStoneTest(x, g)

## all-pairs comparisons
hsAllPairsTest(x, g)
}
\references{
Hayter, A. J.(1990) A One-Sided Studentised Range
Test for Testing Against a Simple Ordered Alternative,
\emph{Journal of the American Statistical Association}
\bold{85}, 778--785.

Hayter, A.J., Stone, G. (1991)
Distribution free multiple comparisons for monotonically ordered treatment effects.
\emph{Austral J Statist} \bold{33}, 335--346.
}
\seealso{
\code{\link{hayterStoneTest}} \code{\link{sample}}
}
\keyword{htest}
\keyword{nonparametric}
