% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goreTest.R
\name{goreTest}
\alias{goreTest}
\title{Gore Test}
\usage{
goreTest(y, groups, blocks)
}
\arguments{
\item{y}{a numeric vector of data values.}

\item{groups}{a vector or factor object giving the group for the
corresponding elements of \code{"y"}.}

\item{blocks}{a vector or factor object giving the group for the
corresponding elements of \code{"y"}.}
}
\value{
A list with class \code{"htest"} containing the following components:
\describe{
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
\item{statistic}{the estimated quantile of the test statistic.}
\item{p.value}{the p-value for the test.}
\item{parameter}{the parameters of the test statistic, if any.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{estimates}{the estimates, if any.}
\item{null.value}{the estimate under the null hypothesis, if any.}
}
}
\description{
Performs Gore's test. The null hypothesis
H\eqn{_0: \theta_i = \theta_j~~(i \ne j)} is tested against the
alternative H\eqn{_{\mathrm{A}}: \theta_i \ne \theta_j}, with at least
one inequality beeing strict.
}
\details{
The function has implemented Gore's test for testing
main effects in unbalanced CRB designs,
i.e. there are one ore more observations per cell.
The statistic is assymptotically chi-squared distributed.
}
\examples{
## Crop Yield of 3 varieties on two
## soil classes
X <-c("130,A,Light
115,A,Light
123,A,Light
142,A,Light
117,A,Heavy
125,A,Heavy
139,A,Heavy
108,B,Light
114,B,Light
124,B,Light
106,B,Light
91,B,Heavy
111,B,Heavy
110,B,Heavy
155,C,Light
146,C,Light
151,C,Light
165,C,Light
97,C,Heavy
108,C,Heavy")
con <- textConnection(X)
x <- read.table(con, header=FALSE, sep=",")
close(con)
colnames(x) <- c("Yield", "Variety", "SoilType")
goreTest(y = x$Yield, groups = x$Variety, blocks = x$SoilType)
}
\references{
Gore, A. P. (1975) Some nonparametric tests and selection
procedures for main effects in two-way layouts.
\emph{Ann. Inst. Stat. Math.} \bold{27}, 487--500.
}
\seealso{
\code{\link{friedmanTest}}, \code{\link{skillingsMackTest}},
\code{\link{durbinTest}}
}
\keyword{htest}
\keyword{nonparametric}
