% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steelsKSampleTest.R
\name{steelsKSampleTest}
\alias{steelsKSampleTest}
\alias{steelsKSampleTest.default}
\alias{steelsKSampleTest.formula}
\title{Steel's k-Treatments vs. Control Test}
\usage{
steelsKSampleTest(x, ...)

\method{steelsKSampleTest}{default}(x, g, alternative = c("two.sided", "greater", "less"), ...)

\method{steelsKSampleTest}{formula}(
  formula,
  data,
  subset,
  na.action,
  alternative = c("two.sided", "greater", "less"),
  ...
)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{alternative}{the alternative hypothesis. Defaults to \code{two.sided}.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"htest"} containing the following components:
\describe{
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
\item{statistic}{the estimated quantile of the test statistic.}
\item{p.value}{the p-value for the test.}
\item{parameter}{the parameters of the test statistic, if any.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{estimates}{the estimates, if any.}
\item{null.value}{the estimate under the null hypothesis, if any.}
}
}
\description{
Performs the non-parametric Steel's test
for simultaneously testing k-treatments vs. one control.
}
\details{
It tests \eqn{H: F(i) = F(0), ~ i \le k}, against
\eqn{A: F(i) > F(0)} (greater) with at least one inequality being strict.

The function is a wrapper function that calls \code{Steel.test} of
the package \pkg{kSamples} with argument \code{method = "asymptotic"}.
}
\examples{
## Example from Sachs (1997, p. 402)
x <- c(106, 114, 116, 127, 145,
110, 125, 143, 148, 151,
136, 139, 149, 160, 174)
g <- gl(3,5)
levels(g) <- c("0", "I", "II")

## Steel's Test
steelsKSampleTest(x ~ g, alternative = "greater")


## Example from USEPA (2002):
## Reproduction data from a Ceriodaphnia dubia
## 7-day chronic test to several concentrations
## of effluent. Dose level 50\% is excluded.
x <- c(20, 26, 26, 23, 24, 27, 26, 23, 27, 24,
13, 15, 14, 13, 23, 26, 0, 25, 26, 27,
18, 22, 13, 13, 23, 22, 20, 22, 23, 22,
14, 22, 20, 23, 20, 23, 25, 24, 25, 21,
9, 0, 9, 7, 6, 10, 12, 14, 9, 13,
rep(0,10))
g <- gl(6, 10)
levels(g) <- c("Control", "3\%", "6\%", "12\%", "25\%", "50\%")

## NOEC at 3\%, LOEC at 6\%
steelsKSampleTest(x ~ g, subset = g != "50\%", alternative = "less")

}
\references{
Scholz, F. and Zhu, A. (2019). kSamples: K-Sample Rank Tests and
their Combinations. R package version 1.2-9.
\url{https://CRAN.R-project.org/package=kSamples}

Steel, R. G. D. (1959) A Multiple Comparison Rank Sum Test:
Treatments Versus Control, \emph{Biometrics} \bold{15}, 560--572.
}
\seealso{
\code{\link[kSamples]{Steel.test}}, \code{\link{flignerWolfeTest}}
}
\keyword{htest}
\keyword{nonparametric}
