% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frdAllPairsMillerTest.R
\name{frdAllPairsMillerTest}
\alias{frdAllPairsMillerTest}
\alias{frdAllPairsMillerTest.default}
\title{Millers's All-Pairs Comparisons Test for Unreplicated Blocked Data}
\usage{
frdAllPairsMillerTest(y, ...)

\method{frdAllPairsMillerTest}{default}(y, groups, blocks, ...)
}
\arguments{
\item{y}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{groups}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}. Ignored with a warning if \code{"x"} is a list.}

\item{blocks}{a vector or factor object giving the block for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{\ldots}{further arguments to be passed to or from methods.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
\item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
\item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs Miller's all-pairs comparisons tests of Friedman-type ranked data.
}
\details{
For all-pairs comparisons in a two factorial unreplicated
complete block design
with non-normally distributed residuals, Miller's test can be
performed on Friedman-type ranked data.

A total of \eqn{m = k ( k -1 )/2} hypotheses can be tested.
The null hypothesis, H\eqn{_{ij}: \theta_i = \theta_j}, is tested
in the two-tailed case against the alternative,
A\eqn{_{ij}: \theta_i \ne \theta_j, ~~ i \ne j}.

The \eqn{p}-values are computed from the chi-square distribution.
}
\examples{
 ## Sachs, 1997, p. 675
 ## Six persons (block) received six different diuretics
 ## (A to F, treatment).
 ## The responses are the Na-concentration (mval)
 ## in the urine measured 2 hours after each treatment.
 ##
 y <- matrix(c(
 3.88, 5.64, 5.76, 4.25, 5.91, 4.33, 30.58, 30.14, 16.92,
 23.19, 26.74, 10.91, 25.24, 33.52, 25.45, 18.85, 20.45,
 26.67, 4.44, 7.94, 4.04, 4.4, 4.23, 4.36, 29.41, 30.72,
 32.92, 28.23, 23.35, 12, 38.87, 33.12, 39.15, 28.06, 38.23,
 26.65),nrow=6, ncol=6,
 dimnames=list(1:6, LETTERS[1:6]))
 print(y)
 friedmanTest(y)

 ## Eisinga et al. 2017
 frdAllPairsExactTest(y=y, p.adjust = "bonferroni")

 ## Conover's test
 frdAllPairsConoverTest(y=y, p.adjust = "bonferroni")

 ## Nemenyi's test
 frdAllPairsNemenyiTest(y=y)

 ## Miller et al.
 frdAllPairsMillerTest(y=y)

 ## Siegel-Castellan
 frdAllPairsSiegelTest(y=y, p.adjust = "bonferroni")

 ## Irrelevant of group order?
 x <- as.vector(y)
 g <- rep(colnames(y), each = length(x)/length(colnames(y)))
 b <- rep(rownames(y), times = length(x)/length(rownames(y)))
 xDF <- data.frame(x, g, b) # grouped by colnames

 frdAllPairsNemenyiTest(xDF$x, groups = xDF$g, blocks = xDF$b)
 o <- order(xDF$b) # order per block increasingly
 frdAllPairsNemenyiTest(xDF$x[o], groups = xDF$g[o], blocks = xDF$b[o])
 o <- order(xDF$x) # order per value increasingly
 frdAllPairsNemenyiTest(xDF$x[o], groups = xDF$g[o], blocks = xDF$b[o])

 ## formula method (only works for Nemenyi)
 frdAllPairsNemenyiTest(x ~ g | b, data = xDF)

}
\references{
Bortz J., Lienert, G. A., Boehnke, K. (1990) \emph{Verteilungsfreie
Methoden in der Biostatistik}. Berlin: Springer.

Miller Jr., R. G. (1996) \emph{Simultaneous statistical inference}.
New York: McGraw-Hill.

Wike, E. L. (2006), \emph{Data Analysis. A Statistical Primer for
Psychology Students}. New Brunswick: Aldine Transaction.
}
\seealso{
\code{\link{friedmanTest}}, \code{\link{friedman.test}},
\code{\link{frdAllPairsExactTest}}, \code{\link{frdAllPairsConoverTest}},
\code{\link{frdAllPairsNemenyiTest}}, \code{\link{frdAllPairsSiegelTest}}
}
\concept{friedmanranks}
\keyword{htest}
\keyword{nonparametric}
