% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chenJanTest.R
\name{chenJanTest}
\alias{chenJanTest}
\alias{chenJanTest.default}
\title{Chen and Jan Many-to-One Comparisons Test}
\usage{
chenJanTest(y, ...)

\method{chenJanTest}{default}(
  y,
  groups,
  blocks,
  alternative = c("greater", "less"),
  p.adjust.method = c("single-step", "SD1", p.adjust.methods),
  ...
)
}
\arguments{
\item{y}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{groups}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}. Ignored with a warning if \code{"x"} is a list.}

\item{blocks}{a vector or factor object giving the block for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{alternative}{the alternative hypothesis. Defaults to \code{greater}.}

\item{p.adjust.method}{method for adjusting p values
(see \code{\link{p.adjust}})}

\item{\ldots}{further arguments to be passed to or from methods.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
\item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
\item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs Chen and Jan nonparametric test for contrasting increasing
(decreasing) dose levels of a treatment in a randomized block design.
}
\details{
Chen's test is a non-parametric step-down trend test for
testing several treatment levels with a zero control. Let
there be \eqn{k} groups including the control and let
the zero dose level be indicated with \eqn{i = 0} and the highest
dose level with \eqn{i = m}, then the following \code{m = k - 1} hypotheses are tested:

\deqn{
\begin{array}{ll}
\mathrm{H}_{m}: \theta_0 = \theta_1 = \ldots = \theta_m, & \mathrm{A}_{m} = \theta_0 \le \theta_1 \le \ldots \theta_m, \theta_0 < \theta_m \\
\mathrm{H}_{m-1}: \theta_0 = \theta_1 = \ldots = \theta_{m-1}, & \mathrm{A}_{m-1} = \theta_0 \le \theta_1 \le \ldots \theta_{m-1}, \theta_0 < \theta_{m-1} \\
\vdots & \vdots \\
\mathrm{H}_{1}: \theta_0 = \theta_1, & \mathrm{A}_{1} = \theta_0 < \theta_1\\
\end{array}
}

Let \eqn{Y_{ij1}, Y_{ij2}, \ldots, Y_{ijn_{ij}}}
\eqn{(i = 1, 2, \dots, b, j = 0, 1, \ldots, k ~ \mathrm{and} ~ n_{ij} \geq 1)} be
a i.i.d. random variable of at least ordinal scale. Further,the zero dose
control is indicated with \eqn{j = 0}.

The Mann-Whittney statistic is

\deqn{
T_{ij} = \sum_{u=0}^{j-1} \sum_{s=1}^{n_{ij}}
\sum_{r=1}^{n_{iu}} I(Y_{ijs} - Y_{iur}),
\qquad i = 1, 2, \ldots, b, ~ j = 1, 2, \ldots, k,
}

where where the indicator function returns \eqn{I(a) = 1, ~ \mathrm{if}~ a > 0, 0.5 ~ \mathrm{if} a = 0}
otherwise \eqn{0}.

Let
\deqn{
N_{ij} = \sum_{s=0}^j n_{is} \qquad  i = 1, 2, \ldots, b, ~ j = 1, 2, \ldots, k,
}

and

\deqn{
T_j = \sum_{i=1}^b T_{ij} \qquad j = 1, 2, \ldots, k.
}

The mean and variance of \eqn{T_j} are

\deqn{
\mu(T_j) = \sum_{i=1}^b n_{ij} ~ N_{ij-1} / 2 \qquad \mathrm{and}
}

\deqn{
 \sigma(T_j) = \sum_{i=1}^b n_{ij} ~ N_{ij-1} \left[
 \left(N_{ij} + 1\right) - \sum_{u=1}^{g_i}
 \left(t_u^3 - t_u \right) /
 \left\{N_{ij} \left(N_{ij} - 1\right) \right\} \right]/ 2,
}

with \eqn{g_i} the number of ties in the \eqn{i}th block and
\eqn{t_u} the size of the tied group \eqn{u}.

The test statistic \eqn{T_j^*} is asymptotically multivariate normal
distributed.

\deqn{
T_j^* = \frac{T_j - \mu(T_j)}{\sigma(T_j)}
}

If \code{p.adjust.method =  "single-step"} than the p-values
are calculated with the probability function of the multivariate
normal distribution with \eqn{\Sigma = I_k}. Otherwise
the standard normal distribution is used to calculate
p-values and any method as available
by \code{\link{p.adjust}} or by the step-down procedure as proposed
by Chen (1999), if \code{p.adjust.method = "SD1"} can be used
to account for \eqn{\alpha}-error inflation.
}
\examples{
## Example from Chen and Jan (2002, p. 306)
## MED is at dose level 2 (0.5 ppm SO2)
y <- c(0.2, 6.2, 0.3, 0.3, 4.9, 1.8, 3.9, 2, 0.3, 2.5, 5.4, 2.3, 12.7,
-0.2, 2.1, 6, 1.8, 3.9, 1.1, 3.8, 2.5, 1.3, -0.8, 13.1, 1.1,
12.8, 18.2, 3.4, 13.5, 4.4, 6.1, 2.8, 4, 10.6, 9, 4.2, 6.7, 35,
9, 12.9, 2, 7.1, 1.5, 10.6)
groups <- gl(4,11, labels = c("0", "0.25", "0.5", "1.0"))
blocks <- structure(rep(1:11, 4), class = "factor",
levels = c("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11"))

summary(chenJanTest(y, groups, blocks, alternative = "greater"))
summary(chenJanTest(y, groups, blocks, alternative = "greater", p.adjust = "SD1"))

}
\references{
Chen, Y.I., Jan, S.L., 2002. Nonparametric Identification of
the Minimum Effective Dose for Randomized Block Designs.
\emph{Commun Stat-Simul Comput} \strong{31}, 301--312.
}
\seealso{
\code{\link[stats]{Normal}} \code{\link[mvtnorm]{pmvnorm}}
}
\concept{wilcoxonranks}
\keyword{htest}
\keyword{nonparametric}
