\name{summary.DV}
\alias{summary.DV}
\alias{print.summary.DV}
\alias{print.DV}

\title{S3 methods for extracting the results of the bound p-value for testing for smooth transition effects on PNAR(p) model
}

\description{
S3 methods for extracting the results of the bound p-value for testing for smooth transition effects on PNAR(\eqn{p}) model.
}

\usage{
\method{summary}{DV}(object, ...)
\method{print}{summary.DV}(x, ...)
\method{print}{DV}(x, ...)
}

\arguments{
\item{object}{
An object containing the results of the function \code{\link{score_test_stnarpq_DV}}.
}
\item{x}{
An object containing the results of the function \code{\link{score_test_stnarpq_DV}}.
}
\item{...}{
Extra arguments the user can pass.
}
}

\details{
The functions print the output of the bound p-value for testing for smooth transition effects on PNAR(\eqn{p}) model.
}

\value{
The functions print the results of the function \code{\link{score_test_stnarpq_DV}}.
}

\references{
Armillotta, M. and K. Fokianos (2022a). Poisson network autoregression.
\url{https://arxiv.org/abs/2104.06296}

Armillotta, M. and K. Fokianos (2022b). Testing linearity for network
autoregressive models.
\url{https://arxiv.org/abs/2202.03852}

Davies, R. B. (1987). Hypothesis testing when a nuisance parameter is
present only under the alternative. \emph{Biometrika} 74, 33-43.

Armillotta, M., Tsagris, M. and Fokianos, K. (2022c). The R-package PNAR
for modelling count network time series.
\url{https://arxiv.org/abs/2211.02582}
}

\author{
Mirko Armillotta, Michail Tsagris and Konstantinos Fokianos.
}

\seealso{
\code{\link{score_test_stnarpq_DV}
}
}

\examples{
data(crime)
data(crime_W)
mod1 <- lin_estimnarpq(crime, crime_W, p = 1)
ca <- mod1$coefs[, 1]
a <- score_test_stnarpq_DV(ca, crime, crime_W, p = 1, d = 1)
print(a)
summary(a)
}


