% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pns_design.R
\name{pns_design}
\alias{pns_design}
\title{Create PNS survey object with its sample design}
\usage{
pns_design(data_pns)
}
\arguments{
\item{data_pns}{A tibble of PNS microdata read with \code{read_pns} function.}
}
\value{
An object of class \code{survey.design} with the data from PNS and its sample design.
}
\description{
This function creates PNS survey object with its sample design for analysis using \code{survey} package functions.
}
\note{
For more information, visit the survey official website <\url{https://www.ibge.gov.br/estatisticas/sociais/saude/9160-pesquisa-nacional-de-saude.html?=&t=o-que-e}> and consult the other functions of this package, described below.
}
\examples{
# Using data read from disk
input_path <- pns_example(path="input_example.txt")
data_path <- pns_example(path="exampledata.txt")
dictionary.path <- pns_example(path="dictionaryexample.xls")
deflator.path <- pns_example(path="deflatorexample.xls")
pns.df <- read_pns(microdata=data_path, input_txt=input_path, vars="J007")
pns.df <- pns_labeller(data_pns=pns.df, dictionary.file=dictionary.path)
pns.df <- pns_deflator(data_pns=pns.df, deflator.file=deflator.path)
\donttest{
pns.svy <- pns_design(data_pns=pns.df)
# Calculating chronic diseases rate
survey::svymean(x=~J007, design=pns.svy, na.rm=TRUE)}
\donttest{
# Downloading data
pns.df2 <- get_pns(year=2019, selected=FALSE, anthropometry=FALSE, vars="J007",
                       labels=TRUE, deflator=TRUE, design=FALSE, savedir=tempdir())
pns.svy2 <- pns_design(data_pns=pns.df2)
# Calculating chronic diseases rate
survey::svymean(x=~J007, design=pns.svy2, na.rm=TRUE)}
}
\seealso{
\link[PNSIBGE]{get_pns} for downloading, labelling, deflating and creating survey design object for PNS microdata.\cr \link[PNSIBGE]{read_pns} for reading PNS microdata.\cr \link[PNSIBGE]{pns_labeller} for labelling categorical variables from PNS microdata.\cr \link[PNSIBGE]{pns_deflator} for adding deflator variable to PNS microdata.\cr \link[PNSIBGE]{pns_example} for getting the path of the PNS example files.
}
