% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross-validation.R
\name{cv.PO.EN}
\alias{cv.PO.EN}
\title{Cross-validation function of PO-EN model}
\usage{
cv.PO.EN(X, Y, alpha=0.5, o.iter=5, i.iter=20,
epsilon=1e-4,nfolds=10,type.measure='deviance',
depth=100,input.pi=0.5,a=sqrt(0.5),seed=1)
}
\arguments{
\item{X}{Input design matrix. Should not include the intercept vector.}

\item{Y}{Response variable. Should be a binary vector.}

\item{alpha}{The elastic net mixing parameter, with \eqn{0\le}\code{alpha}\eqn{\le 1}.}

\item{o.iter}{Number of outer loop iteration.}

\item{i.iter}{Number of inner loop iteration.}

\item{epsilon}{The threshold for stopping the coordinate descent algorithm.}

\item{nfolds}{The number of folds for applying cross validation. The default setting is 10. The number of presence observations must be a multiple of \code{nfolds}.}

\item{type.measure}{The loss function to use for tuning lambda. The default is \code{type.measure='deviance'}. Other choices include
AUROC (\code{type.measure='auc'}) and F measure (\code{type.measure='F.measure'}).}

\item{depth}{The ratio between the largest lambda and the smallest lambda of the candidate sequence of lambda.}

\item{input.pi}{The user-supplied prevalence sequence.}

\item{a}{The parameter of F measure for tuning the true prevalence, the default value is \eqn{\sqrt{0.5}}.}

\item{seed}{A single value used for random number generation of the functions.}
}
\value{
\tabular{ll}{
\tab \cr
\code{lambda.min} \tab value of lambda that returns the minimum (or maximum, \cr
 \tab depending on \code{type.measure}) of mean cross-validated error.\cr
 \tab\cr
\code{lambda.1se} \tab largest value of lambda such that error is within 1 standard error of the minimum.\cr
 \tab \cr
\code{pi} \tab value of the prevalence parameter that returns maximum F measure.\cr
}
}
\description{
Does k-fold cross-validation for PO-EN, produces a pair values of lambda and the prevalence parameter for an optimal fitting.
}
\details{
The cross-validation function runs a n-folds cross-validation for selecting an optimal pair of lambda and the prevalence parameter.
The default setting is 10-folds cross validation. The candidate sequence of lambda is automatically generated by the function based on a warm start.
The values of \code{input.pi} should be supplied by users.
}
\examples{
data(example.data) # example datasets, including training dataset and testing dataset
train_data<-example.data$train.data
y_train=train_data$response;x_train=train_data[,-1]  # response and design matrix of training data
\donttest{PO.EN.cv<-cv.PO.EN(x_train,y_train,input.pi=seq(0.01,0.4,length.out=4))}
\dontshow{PO.EN.cv<-list()
PO.EN.cv$lambda.min<-0.1
PO.EN.cv$pi<-0.2
}
PO.EN.beta<-PO.EN(x_train,y_train,lambda=PO.EN.cv$lambda.min,
           true.prob=PO.EN.cv$pi,beta_start=rep(0,ncol(x_train)+1))
}
