% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pof_design.R
\name{pof_design}
\alias{pof_design}
\title{Create POF survey object with its sample design}
\usage{
pof_design(data_pof)
}
\arguments{
\item{data_pof}{A tibble of POF microdata read with \code{read_pof} function.}
}
\value{
An object of class \code{survey.design} with the data from POF and its sample design.
}
\description{
This function creates POF survey object with its sample design for analysis using \code{survey} package functions.
}
\note{
For more information, visit the survey official website <\url{https://www.ibge.gov.br/estatisticas/sociais/trabalho/9050-pesquisa-de-orcamentos-familiares.html?=&t=o-que-e}> and consult the other functions of this package, described below.
}
\examples{
\donttest{
# Using data read from disk
input_path <- pof_example(path="input_example.txt")
data_path <- pof_example(path="exampledata.txt")
dictionary.path <- pof_example(path="dictionaryexample.xls")
deflator.path <- pof_example(path="deflatorexample.xls")
pof.df <- read_pof(microdata=data_path, input_txt=input_path, vars="V0408")
pof.df <- pof_labeller(data_pof=pof.df, dictionary.file=dictionary.path)
pof.df <- pof_deflator(data_pof=pof.df, deflator.file=deflator.path)}
\donttest{
pof.svy <- pof_design(data_pof=pof.df)
# Calculating expenses or acquisitions rate
if (!is.null(pof.svy)) survey::svymean(x=~V0408, design=pof.svy, na.rm=TRUE)}
\donttest{
# Downloading data
pof.df2 <- get_pof(year=2017, selected=FALSE, anthropometry=FALSE, vars="V0408",
                       labels=TRUE, deflator=TRUE, design=FALSE, savedir=tempdir())
pof.svy2 <- pof_design(data_pof=pof.df2)
# Calculating expenses or acquisitions rate
if (!is.null(pof.svy2)) survey::svymean(x=~V0408, design=pof.svy2, na.rm=TRUE)}
}
\seealso{
\link[POFIBGE]{get_pof} for downloading, labelling, deflating and creating survey design object for POF microdata.\cr \link[POFIBGE]{read_pof} for reading POF microdata.\cr \link[POFIBGE]{pof_labeller} for labelling categorical variables from POF microdata.\cr \link[POFIBGE]{pof_deflator} for adding deflator variable to POF microdata.\cr \link[POFIBGE]{pof_example} for getting the path of the POF example files.
}
