
customSample_v1 = function(sample_size) {
    list(
        sample1 = rnorm(sample_size, mean = 0, sd = 10),
        sample2_h0 = rnorm(sample_size, mean = 0, sd = 10),
        sample2_h1 = rnorm(sample_size, mean = 5, sd = 10)
    )
}
customTest_v1 = function(sample1, sample2_h0, sample2_h1) {
    c(
        p_h0 = t.test(sample1, sample2_h0, 'less', var.equal = TRUE)$p.value,
        p_h1 = t.test(sample1, sample2_h1, 'less', var.equal = TRUE)$p.value
    )
}

df_ps_v1 = sim(fun_obs = customSample_v1,
               n_obs = c(27, 54, 81),
               fun_test = customTest_v1, n_iter = 10)

df_ps_v1b = sim(fun_obs = customSample_v1,
                n_obs = c(41, 61, 82),
                fun_test = customTest_v1, n_iter = 15)

test_that("simulated p values for simple independent t test", {
    expect_equal(df_ps_v1, structure(list(.iter=c(1,1,1,2,2,2,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10),.look=c(1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3),.n_total=c(54,108,162,54,108,162,54,108,162,54,108,162,54,108,162,54,108,162,54,108,162,54,108,162,54,108,162,54,108,162),sample1=structure(c(27,54,81,27,54,81,27,54,81,27,54,81,27,54,81,27,54,81,27,54,81,27,54,81,27,54,81,27,54,81),class=c("numeric","possa_n")),sample2_h=structure(c(27,54,81,27,54,81,27,54,81,27,54,81,27,54,81,27,54,81,27,54,81,27,54,81,27,54,81,27,54,81),class=c("numeric","possa_n")),p_h0=c(0.576399287621398,0.0252173940561962,0.043033893667477,0.990211469589576,0.98411809932444,0.992716454010316,0.679017782057977,0.822283952288327,0.497054047505809,0.329143837989293,0.480855925592497,0.444313503357662,0.149386488938982,0.458751584838812,0.348805068293602,0.958717819134555,0.620155766420805,0.784343689968668,0.804665440152319,0.201811009689721,0.431857887367699,0.724887448596376,0.618068535298541,0.345263554459535,0.136997640140258,0.074845344694713,0.0678576706330372,0.54057601376447,0.785335263364055,0.622776029841852),p_h1=c(0.0206001018800164,0.00015403925031623,3.39880999321152e-05,0.243296852757563,0.270011858722093,0.181288003358646,0.0936052948162417,0.0269026356281129,0.000105557885637387,0.00110319387553142,0.00179055042854996,0.000125704377416475,0.0158233565315866,0.00443533317769165,0.00139214560985826,0.0913096018696819,0.00966375218813079,0.00595604194736614,0.189838647044273,0.00222910405394341,0.000569020481945136,0.135391447179981,0.00316924999844062,0.00180263279729778,0.0538274244503746,0.00585020137844892,0.000269367025602985,0.143962590984133,0.25213748417097,0.0373420451613302)),row.names=c(3L,2L,1L,6L,5L,4L,9L,8L,7L,12L,11L,10L,15L,14L,13L,18L,17L,16L,21L,20L,19L,24L,23L,22L,27L,26L,25L,30L,29L,28L),class=c("possa_sim_df","data.frame")))
    expect_equal(df_ps_v1b, structure(list(.iter=c(1,1,1,2,2,2,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,12,12,12,13,13,13,14,14,14,15,15,15),.look=c(1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3),.n_total=c(82,122,164,82,122,164,82,122,164,82,122,164,82,122,164,82,122,164,82,122,164,82,122,164,82,122,164,82,122,164,82,122,164,82,122,164,82,122,164,82,122,164,82,122,164),sample1=structure(c(41,61,82,41,61,82,41,61,82,41,61,82,41,61,82,41,61,82,41,61,82,41,61,82,41,61,82,41,61,82,41,61,82,41,61,82,41,61,82,41,61,82,41,61,82),class=c("numeric","possa_n")),sample2_h=structure(c(41,61,82,41,61,82,41,61,82,41,61,82,41,61,82,41,61,82,41,61,82,41,61,82,41,61,82,41,61,82,41,61,82,41,61,82,41,61,82,41,61,82,41,61,82),class=c("numeric","possa_n")),p_h0=c(0.203311985051222,0.1419720224789,0.0660549241984845,0.626020453110929,0.838503614731125,0.826444773927893,0.977294288368018,0.989242983189905,0.788688938812757,0.493868891968425,0.351604204128128,0.640695292901211,0.808698665409523,0.843417085621023,0.798393388809175,0.737811203751017,0.808918142735116,0.944883654539515,0.637148164180931,0.894363961213893,0.642439433108591,0.357121568056658,0.36247522540704,0.4052876786475,0.0773412154483688,0.18083357938499,0.0171076920488343,0.852794880843547,0.83930407972114,0.745366989443566,0.298055773697642,0.622990006293229,0.819435611146635,0.516842487209234,0.295065306347317,0.171885170166763,0.687272529547497,0.847694621366875,0.906137824633217,0.722293657734339,0.749958096088846,0.672469734512039,0.0137342508173812,0.00376413911743099,0.00380936896380023),p_h1=c(0.000104574160485693,0.000193491942560995,3.62767375313009e-05,0.0172630959764474,0.002110193801875,0.00275172059669026,0.0325373134365784,0.0224963001002057,0.000482569250369922,0.0014498565584271,0.00276272341170809,0.000622823300341069,0.000282685493567383,0.000338421785411925,0.0021137891863755,0.00300024518438175,3.54402764735681e-05,7.05117420773768e-05,0.0640069103880952,0.0482010827291888,0.0143041901034598,0.218695800750947,0.0311542203309128,0.00928408531585131,0.000963421404646684,0.000609736034795244,7.82138072623634e-07,0.0249103669679157,0.0177114865044572,0.000510637393988299,0.000656459271165474,0.00759447067173795,0.00552982717340924,0.167800333722471,0.0315044678256722,0.0031542893456982,0.00203586206095136,0.00205743192011981,0.00140067501172714,0.00838748784899175,0.0164253944801389,0.0128859598480054,3.33728262660358e-05,3.33863543292687e-07,7.64894789817197e-07)),row.names=c(3L,2L,1L,6L,5L,4L,9L,8L,7L,12L,11L,10L,15L,14L,13L,18L,17L,16L,21L,20L,19L,24L,23L,22L,27L,26L,25L,30L,29L,28L,33L,32L,31L,36L,35L,34L,39L,38L,37L,42L,41L,40L,45L,44L,43L),class=c("possa_sim_df","data.frame")))
})


pow_fix = pow(df_ps_v1)
pow_NA = pow(df_ps_v1, alpha_locals = NA)
pow_NA_part = pow(df_ps_v1, alpha_locals = c(NA, NA, 0.05), fut_locals = 0.5)
pow_fut1 = pow(df_ps_v1, fut_locals = 0.5)
pow_fut2 = pow(df_ps_v1, fut_locals = c(0.8, 0.5))
pow_NA_fut = pow(df_ps_v1, alpha_locals = c(NA, NA, 0.05), fut_locals = 0.5)
pow_alphas_fut = pow(df_ps_v1, alpha_locals = c(0, 0.05, 0.025), fut_locals = c(0.8, 0.5))
pow_set_global1 = pow(df_ps_v1b, alpha_locals = NA, alpha_global = 0.025)
pow_set_global2 = pow(df_ps_v1b, alpha_locals = NA, alpha_global = 0.1)

test_that("power output for simple independent t test", {
    expect_equal(pow_fix$pow, structure(list(look=c("1","2","3","totals"),n=c(54,108,162,324),n_rate=c(0.333333333333333,0.666666666666667,1,2),iters_sign_h0=c(0,0,1,1),iters_sign_h1=c(0,0,9,9),iters_sign_p_h0=c(0,0,1,1),iters_sign_p_h1=c(0,0,9,9),iters_remain_h0=c(10,10,0,20),iters_remain_h1=c(10,10,0,20),iters_stopped_h0=c(0,0,10,10),iters_stopped_h1=c(0,0,10,10),alpha_local_p=structure(c(0,0,0.05,0.05),class=c("numeric","possa_p")),ratio_sign_p_h0=c(0,0,0.1,0.1),ratio_sign_p_h1=c(0,0,0.9,0.9),ratio_stopped_h0=c(0,0,1,1),ratio_stopped_h1=c(0,0,1,1),ratio_combined_sign_h0=c(0,0,0.1,0.1),ratio_combined_sign_h1=c(0,0,0.9,0.9),ratio_remain_h0=c(1,1,0,2),ratio_remain_h1=c(1,1,0,2),n_avg_prop_0=c(0,0,162,162),n_avg_prop_1=c(0,0,162,162)),row.names=c(NA,-4L),class=c("possa_pow_df","data.frame")))

    expect_equal(pow_NA$pow, structure(list(look=c("1","2","3","totals"),n=c(54,108,162,324),n_rate=c(0.333333333333333,0.666666666666667,1,2),iters_sign_h0=c(0,0,0,0),iters_sign_h1=c(3,4,1,8),iters_sign_p_h0=c(0,0,0,0),iters_sign_p_h1=c(3,4,1,8),iters_remain_h0=c(10,10,0,20),iters_remain_h1=c(7,3,0,10),iters_stopped_h0=c(0,0,10,10),iters_stopped_h1=c(3,4,3,10),alpha_local_p=structure(c(0.0252115885416667,0.0252115885416667,0.0252115885416667,0.075634765625),class=c("numeric","possa_p")),ratio_sign_p_h0=c(0,0,0,0),ratio_sign_p_h1=c(0.3,0.4,0.1,0.8),ratio_stopped_h0=c(0,0,1,1),ratio_stopped_h1=c(0.3,0.4,0.3,1),ratio_combined_sign_h0=c(0,0,0,0),ratio_combined_sign_h1=c(0.3,0.4,0.1,0.8),ratio_remain_h0=c(1,1,0,2),ratio_remain_h1=c(0.7,0.3,0,1),n_avg_prop_0=c(0,0,162,162),n_avg_prop_1=c(16.2,43.2,48.6,108)),row.names=c(NA,-4L),class=c("possa_pow_df","data.frame"))
                 )

    expect_equal(pow_NA_part$pow, structure(list(look=c("1","2","3","totals"),n=c(54,108,162,324),n_rate=c(0.333333333333333,0.666666666666667,1,2),iters_sign_h0=c(0,0,0,0),iters_sign_h1=c(4,4,1,9),iters_fut_h0=c(7,0,3,10),iters_fut_h1=c(0,0,2,2),iters_sign_p_h0=c(0,0,0,0),iters_sign_p_h1=c(4,4,1,9),iters_futil_p_h0=c(1,3,2,6),iters_futil_p_h1=c(0,0,2,2),iters_remain_h0=c(3,3,0,6),iters_remain_h1=c(6,2,0,8),iters_stopped_h0=c(7,0,3,10),iters_stopped_h1=c(4,4,2,10),alpha_local_p=structure(c(0.0748404947916667,0.0748404947916667,0.05,0.199680989583333),class=c("numeric","possa_p")),futil_local_p=structure(c(0.5,0.5,NA,NA),class=c("numeric","possa_p","possa_futility")),ratio_sign_p_h0=c(0,0,0,0),ratio_futil_p_h0=c(0.1,0.3,0.2,0.6),ratio_sign_p_h1=c(0.4,0.4,0.1,0.9),ratio_futil_p_h1=c(0,0,0.2,0.2),ratio_stopped_h0=c(0.7,0,0.3,1),ratio_stopped_h1=c(0.4,0.4,0.2,1),ratio_combined_sign_h0=c(0,0,0,0),ratio_combined_sign_h1=c(0.4,0.4,0.1,0.9),ratio_combined_fut_h0=c(0.7,0,0.3,1),ratio_combined_fut_h1=c(0,0,0.2,0.2),ratio_remain_h0=c(0.3,0.3,0,0.6),ratio_remain_h1=c(0.6,0.2,0,0.8),n_avg_prop_0=c(37.8,0,48.6,86.4),n_avg_prop_1=c(21.6,43.2,32.4,97.2)),row.names=c(NA,-4L),class=c("possa_pow_df","data.frame")))

    expect_equal(pow_fut1$pow, structure(list(look=c("1","2","3","totals"),n=c(54,108,162,324),n_rate=c(0.333333333333333,0.666666666666667,1,2),iters_sign_h0=c(0,0,0,0),iters_sign_h1=c(0,0,9,9),iters_fut_h0=c(7,0,3,10),iters_fut_h1=c(0,0,10,10),iters_sign_p_h0=c(0,0,0,0),iters_sign_p_h1=c(0,0,9,9),iters_futil_p_h0=c(0,0,10,10),iters_futil_p_h1=c(0,0,10,10),iters_remain_h0=c(3,3,0,6),iters_remain_h1=c(10,10,0,20),iters_stopped_h0=c(7,0,3,10),iters_stopped_h1=c(0,0,10,10),alpha_local_p=structure(c(0,0,0.05,0.05),class=c("numeric","possa_p")),futil_local_p=structure(c(0.5,0.5,NA,NA),class=c("numeric","possa_p","possa_futility")),ratio_sign_p_h0=c(0,0,0,0),ratio_futil_p_h0=c(0,0,1,1),ratio_sign_p_h1=c(0,0,0.9,0.9),ratio_futil_p_h1=c(0,0,1,1),ratio_stopped_h0=c(0.7,0,0.3,1),ratio_stopped_h1=c(0,0,1,1),ratio_combined_sign_h0=c(0,0,0,0),ratio_combined_sign_h1=c(0,0,0.9,0.9),ratio_combined_fut_h0=c(0.7,0,0.3,1),ratio_combined_fut_h1=c(0,0,1,1),ratio_remain_h0=c(0.3,0.3,0,0.6),ratio_remain_h1=c(1,1,0,2),n_avg_prop_0=c(37.8,0,48.6,86.4),n_avg_prop_1=c(0,0,162,162)),row.names=c(NA,-4L),class=c("possa_pow_df","data.frame")))

    expect_equal(pow_fut2$pow, structure(list(look=c("1","2","3","totals"),n=c(54,108,162,324),n_rate=c(0.333333333333333,0.666666666666667,1,2),iters_sign_h0=c(0,0,1,1),iters_sign_h1=c(0,0,9,9),iters_fut_h0=c(3,3,4,10),iters_fut_h1=c(0,0,10,10),iters_sign_p_h0=c(0,0,1,1),iters_sign_p_h1=c(0,0,9,9),iters_futil_p_h0=c(0,0,10,10),iters_futil_p_h1=c(0,0,10,10),iters_remain_h0=c(7,4,0,11),iters_remain_h1=c(10,10,0,20),iters_stopped_h0=c(3,3,4,10),iters_stopped_h1=c(0,0,10,10),alpha_local_p=structure(c(0,0,0.05,0.05),class=c("numeric","possa_p")),futil_local_p=structure(c(0.8,0.5,NA,NA),class=c("numeric","possa_p","possa_futility")),ratio_sign_p_h0=c(0,0,0.1,0.1),ratio_futil_p_h0=c(0,0,1,1),ratio_sign_p_h1=c(0,0,0.9,0.9),ratio_futil_p_h1=c(0,0,1,1),ratio_stopped_h0=c(0.3,0.3,0.4,1),ratio_stopped_h1=c(0,0,1,1),ratio_combined_sign_h0=c(0,0,0.1,0.1),ratio_combined_sign_h1=c(0,0,0.9,0.9),ratio_combined_fut_h0=c(0.3,0.3,0.4,1),ratio_combined_fut_h1=c(0,0,1,1),ratio_remain_h0=c(0.7,0.4,0,1.1),ratio_remain_h1=c(1,1,0,2),n_avg_prop_0=c(16.2,32.4,64.8,113.4),n_avg_prop_1=c(0,0,162,162)),row.names=c(NA,-4L),class=c("possa_pow_df","data.frame")))

    expect_equal(pow_NA_fut$pow, structure(list(look=c("1","2","3","totals"),n=c(54,108,162,324),n_rate=c(0.333333333333333,0.666666666666667,1,2),iters_sign_h0=c(0,0,0,0),iters_sign_h1=c(4,4,1,9),iters_fut_h0=c(7,0,3,10),iters_fut_h1=c(0,0,2,2),iters_sign_p_h0=c(0,0,0,0),iters_sign_p_h1=c(4,4,1,9),iters_futil_p_h0=c(1,3,2,6),iters_futil_p_h1=c(0,0,2,2),iters_remain_h0=c(3,3,0,6),iters_remain_h1=c(6,2,0,8),iters_stopped_h0=c(7,0,3,10),iters_stopped_h1=c(4,4,2,10),alpha_local_p=structure(c(0.0748404947916667,0.0748404947916667,0.05,0.199680989583333),class=c("numeric","possa_p")),futil_local_p=structure(c(0.5,0.5,NA,NA),class=c("numeric","possa_p","possa_futility")),ratio_sign_p_h0=c(0,0,0,0),ratio_futil_p_h0=c(0.1,0.3,0.2,0.6),ratio_sign_p_h1=c(0.4,0.4,0.1,0.9),ratio_futil_p_h1=c(0,0,0.2,0.2),ratio_stopped_h0=c(0.7,0,0.3,1),ratio_stopped_h1=c(0.4,0.4,0.2,1),ratio_combined_sign_h0=c(0,0,0,0),ratio_combined_sign_h1=c(0.4,0.4,0.1,0.9),ratio_combined_fut_h0=c(0.7,0,0.3,1),ratio_combined_fut_h1=c(0,0,0.2,0.2),ratio_remain_h0=c(0.3,0.3,0,0.6),ratio_remain_h1=c(0.6,0.2,0,0.8),n_avg_prop_0=c(37.8,0,48.6,86.4),n_avg_prop_1=c(21.6,43.2,32.4,97.2)),row.names=c(NA,-4L),class=c("possa_pow_df","data.frame")))

    expect_equal(pow_alphas_fut$pow, structure(list(look=c("1","2","3","totals"),n=c(54,108,162,324),n_rate=c(0.333333333333333,0.666666666666667,1,2),iters_sign_h0=c(0,0,0,0),iters_sign_h1=c(0,7,1,8),iters_fut_h0=c(3,3,4,10),iters_fut_h1=c(0,0,3,3),iters_sign_p_h0=c(0,0,0,0),iters_sign_p_h1=c(0,7,1,8),iters_futil_p_h0=c(0,2,3,5),iters_futil_p_h1=c(0,0,3,3),iters_remain_h0=c(7,4,0,11),iters_remain_h1=c(10,3,0,13),iters_stopped_h0=c(3,3,4,10),iters_stopped_h1=c(0,7,3,10),alpha_local_p=structure(c(0,0.0251953125,0.01259765625,0.03779296875),class=c("numeric","possa_p")),futil_local_p=structure(c(0.8,0.5,NA,NA),class=c("numeric","possa_p","possa_futility")),ratio_sign_p_h0=c(0,0,0,0),ratio_futil_p_h0=c(0,0.2,0.3,0.5),ratio_sign_p_h1=c(0,0.7,0.1,0.8),ratio_futil_p_h1=c(0,0,0.3,0.3),ratio_stopped_h0=c(0.3,0.3,0.4,1),ratio_stopped_h1=c(0,0.7,0.3,1),ratio_combined_sign_h0=c(0,0,0,0),ratio_combined_sign_h1=c(0,0.7,0.1,0.8),ratio_combined_fut_h0=c(0.3,0.3,0.4,1),ratio_combined_fut_h1=c(0,0,0.3,0.3),ratio_remain_h0=c(0.7,0.4,0,1.1),ratio_remain_h1=c(1,0.3,0,1.3),n_avg_prop_0=c(16.2,32.4,64.8,113.4),n_avg_prop_1=c(0,75.6,48.6,124.2)),row.names=c(NA,-4L),class=c("possa_pow_df","data.frame")))

    expect_equal(pow_set_global1$pow, structure(list(look=c("1","2","3","totals"),n=c(82,122,164,368),n_rate=c(0.5,0.74390243902439,1,2.24390243902439),iters_sign_h0=c(0,0,0,0),iters_sign_h1=c(8,1,3,12),iters_sign_p_h0=c(0,0,0,0),iters_sign_p_h1=c(8,1,3,12),iters_remain_h0=c(15,15,0,30),iters_remain_h1=c(7,6,0,13),iters_stopped_h0=c(0,0,15,15),iters_stopped_h1=c(8,1,6,15),alpha_local_p=structure(c(0.00376302083333333,0.00376302083333333,0.00376302083333333,0.0112890625),class=c("numeric","possa_p")),ratio_sign_p_h0=c(0,0,0,0),ratio_sign_p_h1=c(0.533333333333333,0.0666666666666667,0.2,0.8),ratio_stopped_h0=c(0,0,1,1),ratio_stopped_h1=c(0.533333333333333,0.0666666666666667,0.4,1),ratio_combined_sign_h0=c(0,0,0,0),ratio_combined_sign_h1=c(0.533333333333333,0.0666666666666667,0.2,0.8),ratio_remain_h0=c(1,1,0,2),ratio_remain_h1=c(0.466666666666667,0.4,0,0.866666666666667),n_avg_prop_0=c(0,0,164,164),n_avg_prop_1=c(43.7333333333333,8.13333333333333,65.6,117.466666666667)),row.names=c(NA,-4L),class=c("possa_pow_df","data.frame")))

    expect_equal(pow_set_global2$pow, structure(list(look=c("1","2","3","totals"),n=c(82,122,164,368),n_rate=c(0.5,0.74390243902439,1,2.24390243902439),iters_sign_h0=c(1,0,0,1),iters_sign_h1=c(9,1,5,15),iters_sign_p_h0=c(1,0,0,1),iters_sign_p_h1=c(9,1,5,15),iters_remain_h0=c(14,14,0,28),iters_remain_h1=c(6,5,0,11),iters_stopped_h0=c(1,0,14,15),iters_stopped_h1=c(9,1,5,15),alpha_local_p=structure(c(0.0171028645833333,0.0171028645833333,0.0171028645833333,0.05130859375),class=c("numeric","possa_p")),ratio_sign_p_h0=c(0.0666666666666667,0,0,0.0666666666666667),ratio_sign_p_h1=c(0.6,0.0666666666666667,0.333333333333333,1),ratio_stopped_h0=c(0.0666666666666667,0,0.933333333333333,1),ratio_stopped_h1=c(0.6,0.0666666666666667,0.333333333333333,1),ratio_combined_sign_h0=c(0.0666666666666667,0,0,0.0666666666666667),ratio_combined_sign_h1=c(0.6,0.0666666666666667,0.333333333333333,1),ratio_remain_h0=c(0.933333333333333,0.933333333333333,0,1.86666666666667),ratio_remain_h1=c(0.4,0.333333333333333,0,0.733333333333333),n_avg_prop_0=c(5.46666666666667,0,153.066666666667,158.533333333333),n_avg_prop_1=c(49.2,8.13333333333333,54.6666666666667,112)),row.names=c(NA,-4L),class=c("possa_pow_df","data.frame")))
})

# paired samples

customSample_v2 = function(samp_size) {
    correlated_samples = faux::rnorm_multi(n = samp_size, vars = 3, mu = c(0, 0, 5), sd = 10, r = c(.5, .5, 0))
    list(
        GRP_v1 = correlated_samples$X1, # correlated with both X2 and X3
        GRP_v2_h0 = correlated_samples$X2, # correlated only with X1
        GRP_v2_h1 = correlated_samples$X3  # correlated only with X1
    )
}
customSample_v2_alt = function(GRP_v1, GRP_v2_h) {
    correlated_samples = faux::rnorm_multi(n = GRP_v1, vars = 3, mu = c(0, 0, 5), sd = 10, r = c(.5, .5, 0))
    list(
        GRP_v1 = correlated_samples$X1, # correlated with both X2 and X3
        GRP_v2_h0 = correlated_samples$X2, # correlated only with X1
        GRP_v2_h1 = correlated_samples$X3  # correlated only with X1
    )
}

customTest_v2 = function(GRP_v1, GRP_v2_h0, GRP_v2_h1) {
    c(
        p_h0 = t.test(GRP_v1, GRP_v2_h0, 'less', paired = TRUE, var.equal = TRUE)$p.value,
        p_h1 = t.test(GRP_v1, GRP_v2_h1, 'less', paired = TRUE, var.equal = TRUE)$p.value
    )
}

df_ps_v2 = sim(
    fun_obs = customSample_v2,
    n_obs = c(33, 66, 99),
    fun_test = customTest_v2, n_iter = 10
)
df_ps_v2_paired = sim(
    fun_obs = customSample_v2,
    n_obs = c(33, 66, 99),
    fun_test = customTest_v2,
    pair = TRUE, n_iter = 10
)
df_ps_v2_unpaired = sim(
    fun_obs = customSample_v2,
    n_obs = c(33, 66, 99),
    fun_test = customTest_v2,
    pair = FALSE, n_iter = 10
)
df_ps_v2_alt = sim(
    fun_obs = customSample_v2_alt,
    n_obs = list(GRP_v1 = c(33, 66, 99), GRP_v2_h = c(33, 66, 99)),
    fun_test = customTest_v2, n_iter = 10
)
df_ps_v2b = sim(
    fun_obs = customSample_v2,
    n_obs = c(33, 44, 55, 66, 77, 88, 99),
    fun_test = customTest_v2, n_iter = 10
)

test_that("simulated p values for paired t test", {
    expect_equal(df_ps_v2, structure(list(.iter=c(1,1,1,2,2,2,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10),.look=c(1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3),.n_total=c(33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99),GRP=structure(c(33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99),class=c("numeric","possa_n")),p_h0=c(0.00418077116218419,0.0388166775755037,0.0979118948634984,0.146496765535831,0.456537724394033,0.139218272331013,0.946426210780797,0.648918468677459,0.636803826697763,0.0905851515995057,0.191226225348206,0.173815595223202,0.395819292925218,0.808674959228112,0.70789585649349,0.0194373076385426,0.268590339942318,0.376969038226714,0.995046587319556,0.820784935176104,0.846049415562802,0.203276368276092,0.26040164168147,0.638632925643337,0.656678921516476,0.59240004901577,0.481249412974051,0.790066664642919,0.607593394281335,0.783403758242822),p_h1=c(5.61337829392741e-06,5.04714092857606e-06,5.93000599356878e-09,0.0127996466739101,0.00296894803622435,5.81873724871795e-06,0.00160451439379029,3.58234396119081e-06,5.38583586936947e-08,0.000400902757149614,4.13180110746921e-06,1.39469456889868e-07,0.0251073696253504,0.00118192171898591,1.78919246600046e-06,0.00186070938538377,1.85332136849034e-06,1.15248911188798e-07,0.00146100048996907,9.14072657971498e-05,2.0827590406759e-07,0.00744129976024904,8.41202948239735e-05,1.51918726938967e-07,0.0035967457346201,0.000293364973572294,3.10274875235237e-06,0.0852488664137241,0.000119879349260158,3.89982305640396e-05)),row.names=c(3L,2L,1L,6L,5L,4L,9L,8L,7L,12L,11L,10L,15L,14L,13L,18L,17L,16L,21L,20L,19L,24L,23L,22L,27L,26L,25L,30L,29L,28L),class=c("possa_sim_df","data.frame")))

    expect_equal(df_ps_v2_alt, structure(list(.iter=c(1,1,1,2,2,2,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10),.look=c(1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3),.n_total=c(33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99),GRP=structure(c(33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99),class=c("numeric","possa_n")),p_h0=c(0.00418077116218419,0.0388166775755037,0.0979118948634984,0.146496765535831,0.456537724394033,0.139218272331013,0.946426210780797,0.648918468677459,0.636803826697763,0.0905851515995057,0.191226225348206,0.173815595223202,0.395819292925218,0.808674959228112,0.70789585649349,0.0194373076385426,0.268590339942318,0.376969038226714,0.995046587319556,0.820784935176104,0.846049415562802,0.203276368276092,0.26040164168147,0.638632925643337,0.656678921516476,0.59240004901577,0.481249412974051,0.790066664642919,0.607593394281335,0.783403758242822),p_h1=c(5.61337829392741e-06,5.04714092857606e-06,5.93000599356878e-09,0.0127996466739101,0.00296894803622435,5.81873724871795e-06,0.00160451439379029,3.58234396119081e-06,5.38583586936947e-08,0.000400902757149614,4.13180110746921e-06,1.39469456889868e-07,0.0251073696253504,0.00118192171898591,1.78919246600046e-06,0.00186070938538377,1.85332136849034e-06,1.15248911188798e-07,0.00146100048996907,9.14072657971498e-05,2.0827590406759e-07,0.00744129976024904,8.41202948239735e-05,1.51918726938967e-07,0.0035967457346201,0.000293364973572294,3.10274875235237e-06,0.0852488664137241,0.000119879349260158,3.89982305640396e-05)),row.names=c(3L,2L,1L,6L,5L,4L,9L,8L,7L,12L,11L,10L,15L,14L,13L,18L,17L,16L,21L,20L,19L,24L,23L,22L,27L,26L,25L,30L,29L,28L),class=c("possa_sim_df","data.frame")))

    expect_equal(df_ps_v2_paired, structure(list(.iter=c(1,1,1,2,2,2,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10),.look=c(1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3),.n_total=c(33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99),GRP=structure(c(33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99),class=c("numeric","possa_n")),p_h0=c(0.00418077116218419,0.0388166775755037,0.0979118948634984,0.146496765535831,0.456537724394033,0.139218272331013,0.946426210780797,0.648918468677459,0.636803826697763,0.0905851515995057,0.191226225348206,0.173815595223202,0.395819292925218,0.808674959228112,0.70789585649349,0.0194373076385426,0.268590339942318,0.376969038226714,0.995046587319556,0.820784935176104,0.846049415562802,0.203276368276092,0.26040164168147,0.638632925643337,0.656678921516476,0.59240004901577,0.481249412974051,0.790066664642919,0.607593394281335,0.783403758242822),p_h1=c(5.61337829392741e-06,5.04714092857606e-06,5.93000599356878e-09,0.0127996466739101,0.00296894803622435,5.81873724871795e-06,0.00160451439379029,3.58234396119081e-06,5.38583586936947e-08,0.000400902757149614,4.13180110746921e-06,1.39469456889868e-07,0.0251073696253504,0.00118192171898591,1.78919246600046e-06,0.00186070938538377,1.85332136849034e-06,1.15248911188798e-07,0.00146100048996907,9.14072657971498e-05,2.0827590406759e-07,0.00744129976024904,8.41202948239735e-05,1.51918726938967e-07,0.0035967457346201,0.000293364973572294,3.10274875235237e-06,0.0852488664137241,0.000119879349260158,3.89982305640396e-05)),row.names=c(3L,2L,1L,6L,5L,4L,9L,8L,7L,12L,11L,10L,15L,14L,13L,18L,17L,16L,21L,20L,19L,24L,23L,22L,27L,26L,25L,30L,29L,28L),class=c("possa_sim_df","data.frame")))

    expect_equal(df_ps_v2_unpaired, structure(list(.iter=c(1,1,1,2,2,2,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10),.look=c(1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3),.n_total=c(33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99),GRP=structure(c(33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99,33,66,99),class=c("numeric","possa_n")),p_h0=c(0.0441223144839926,0.184007875811232,0.0979118948634984,0.769661538220183,0.925026033754017,0.987249465446197,0.44369688240442,0.642796410911526,0.771981167709606,0.517343131248815,0.713724294849502,0.35023744097159,0.722532352178107,0.909386212548767,0.531306287006423,0.309733773298187,0.33916725094456,0.690077704390241,0.997506008270582,0.75428489678364,0.628864303446589,0.699683485196396,0.406929728654239,0.665627644584279,0.896399920575965,0.378819308008637,0.0873167483582613,0.721402614178792,0.745515105909045,0.529158743099637),p_h1=c(0.000300284083410956,0.000164917042019025,5.93000599356878e-09,0.224165741443058,0.0188624375333414,1.12561757690543e-05,0.00631326475218115,6.24306182675149e-05,2.64624844682706e-10,0.0720753684640943,0.00149455149175597,6.09781080036427e-05,0.104254401593204,0.112420217466588,0.000141597659725397,0.0951828710121214,0.00521357451370861,0.000429337384596872,0.128964195104496,0.000147386152711857,1.80265360022669e-06,0.162044509898156,0.0024941105573205,1.89852360535835e-07,0.0546795862035866,0.00740648215223548,1.47980493601476e-05,0.0569733286522184,0.0138537273731882,5.00652834262562e-05)),row.names=c(3L,2L,1L,6L,5L,4L,9L,8L,7L,12L,11L,10L,15L,14L,13L,18L,17L,16L,21L,20L,19L,24L,23L,22L,27L,26L,25L,30L,29L,28L),class=c("possa_sim_df","data.frame")))

    expect_equal(df_ps_v2b, structure(list(.iter=c(1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,3,3,4,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,8,9,9,9,9,9,9,9,10,10,10,10,10,10,10),.look=c(1,2,3,4,5,6,7,1,2,3,4,5,6,7,1,2,3,4,5,6,7,1,2,3,4,5,6,7,1,2,3,4,5,6,7,1,2,3,4,5,6,7,1,2,3,4,5,6,7,1,2,3,4,5,6,7,1,2,3,4,5,6,7,1,2,3,4,5,6,7),.n_total=c(33,44,55,66,77,88,99,33,44,55,66,77,88,99,33,44,55,66,77,88,99,33,44,55,66,77,88,99,33,44,55,66,77,88,99,33,44,55,66,77,88,99,33,44,55,66,77,88,99,33,44,55,66,77,88,99,33,44,55,66,77,88,99,33,44,55,66,77,88,99),GRP=structure(c(33,44,55,66,77,88,99,33,44,55,66,77,88,99,33,44,55,66,77,88,99,33,44,55,66,77,88,99,33,44,55,66,77,88,99,33,44,55,66,77,88,99,33,44,55,66,77,88,99,33,44,55,66,77,88,99,33,44,55,66,77,88,99,33,44,55,66,77,88,99),class=c("numeric","possa_n")),p_h0=c(0.264409378889399,0.369572048980508,0.270026073373262,0.175626754671786,0.0960178321065005,0.106887188202263,0.0979118948634984,0.992301043197545,0.948541530126992,0.940208959628271,0.978090166048095,0.982205496727473,0.969631994348483,0.979846015247699,0.675688110719642,0.609087511053927,0.712159234537312,0.523902177347727,0.350371026228337,0.217917304881909,0.215822712553559,0.35028900338539,0.390906983394794,0.236192771997888,0.231122041682674,0.178767863040009,0.215538522343242,0.278324503923263,0.834715263544378,0.515771077302629,0.499920555100467,0.604505270753952,0.815115951871447,0.838134616182006,0.77717461526542,0.521106794287333,0.277894680785809,0.100340737256113,0.139258216717118,0.0548449575373134,0.147241420282134,0.217525934938581,0.918561483162295,0.740456934763267,0.775897048491384,0.794028779446238,0.849858232252497,0.869134448052544,0.751453516200588,0.596291886998252,0.755421094377154,0.405720825744308,0.542509709303854,0.622257863541494,0.539219226258186,0.440698430780773,0.86025736351266,0.768484913702134,0.601394416648237,0.423755069245568,0.180980343202166,0.443098209987941,0.558160498585175,0.678727081480264,0.753154711890197,0.798636828011948,0.787155827682861,0.877358476045483,0.834483701534099,0.763601226366846),p_h1=c(0.000325494962260686,6.73484332133282e-05,2.87597040869761e-05,6.30631244593753e-06,6.71082268448038e-07,2.56664502734651e-08,5.93000599356878e-09,0.00078068252089585,0.00017434861622328,4.58831803681193e-05,2.0560860639045e-05,3.49097273514444e-07,1.38014491883796e-06,1.4125049241034e-06,0.00374842435841062,0.00311188120161447,0.000641883221241434,0.000376429732494457,1.50149386671058e-05,1.37628796662047e-06,5.67344427432327e-07,0.000209543938621797,0.000280529275440748,1.69352280970828e-05,4.43513801596973e-06,5.54141422577359e-06,1.08573224447902e-06,1.52465278506371e-06,1.37059118484922e-06,8.53542004107336e-05,1.348179058304e-05,3.35853772751509e-06,4.13100994571407e-07,5.21971936758169e-07,5.70300697508646e-07,0.000260745122241926,0.000664024185194709,0.000123564802390192,4.8738327953437e-05,2.90822993542737e-06,2.02669517397634e-07,4.557994095257e-07,0.00731620630514769,0.00208830221378096,0.000849620222903283,0.000859315387168422,7.3811924628501e-05,2.8479075353833e-05,3.13860798809203e-06,9.54564575666387e-07,1.0924868591975e-07,1.05825092957492e-08,4.07019459265728e-10,1.28634823233973e-08,7.56337306866327e-10,4.5753419820955e-11,0.000944786538434863,0.00503127672977899,0.00260213805032569,0.000302985360486084,4.10785505359841e-05,6.19963403615319e-06,2.7013733413647e-07,0.000185511455892696,2.0986966000279e-05,4.61102580410649e-05,3.85502755323273e-05,3.79955788420956e-06,8.20775707984459e-07,1.16691318414026e-05)),row.names=c(7L,6L,5L,4L,3L,2L,1L,14L,13L,12L,11L,10L,9L,8L,21L,20L,19L,18L,17L,16L,15L,28L,27L,26L,25L,24L,23L,22L,35L,34L,33L,32L,31L,30L,29L,42L,41L,40L,39L,38L,37L,36L,49L,48L,47L,46L,45L,44L,43L,56L,55L,54L,53L,52L,51L,50L,63L,62L,61L,60L,59L,58L,57L,70L,69L,68L,67L,66L,65L,64L),class=c("possa_sim_df","data.frame")))
})

pow_paired_NA = pow(df_ps_v2, alpha_locals = NA) # 3 looks
pow_paired_NA_fut = pow(df_ps_v2, fut_locals = 0.5, alpha_locals = NA)
pow_paired_futs = pow(df_ps_v2, fut_locals = c(0.5, 0.2))
pow_unpaired_futs = pow(df_ps_v2_unpaired, fut_locals = 0.5) # unpaired explicitly
pow_paired_7 = pow(df_ps_v2b, alpha_locals = NA) # 7 looks

test_that("power output for paired t test", {
    expect_equal(pow_paired_NA$pow, structure(list(look=c("1","2","3","totals"),n=c(33,66,99,198),n_rate=c(0.333333333333333,0.666666666666667,1,2),iters_sign_h0=c(0,0,0,0),iters_sign_h1=c(6,4,0,10),iters_sign_p_h0=c(0,0,0,0),iters_sign_p_h1=c(6,4,0,10),iters_remain_h0=c(10,10,0,20),iters_remain_h1=c(4,0,0,4),iters_stopped_h0=c(0,0,10,10),iters_stopped_h1=c(6,4,0,10),alpha_local_p=structure(c(0.00417643229166667,0.00417643229166667,0.00417643229166667,0.012529296875),class=c("numeric","possa_p")),ratio_sign_p_h0=c(0,0,0,0),ratio_sign_p_h1=c(0.6,0.4,0,1),ratio_stopped_h0=c(0,0,1,1),ratio_stopped_h1=c(0.6,0.4,0,1),ratio_combined_sign_h0=c(0,0,0,0),ratio_combined_sign_h1=c(0.6,0.4,0,1),ratio_remain_h0=c(1,1,0,2),ratio_remain_h1=c(0.4,0,0,0.4),n_avg_prop_0=c(0,0,99,99),n_avg_prop_1=c(19.8,26.4,0,46.2)),row.names=c(NA,-4L),class=c("possa_pow_df","data.frame")))

    expect_equal(pow_paired_NA_fut$pow, structure(list(look=c("1","2","3","totals"),n=c(33,66,99,198),n_rate=c(0.333333333333333,0.666666666666667,1,2),iters_sign_h0=c(0,0,0,0),iters_sign_h1=c(6,4,0,10),iters_fut_h0=c(4,1,5,10),iters_fut_h1=c(0,0,0,0),iters_sign_p_h0=c(0,0,0,0),iters_sign_p_h1=c(6,4,0,10),iters_futil_p_h0=c(3,2,0,5),iters_futil_p_h1=c(0,0,0,0),iters_remain_h0=c(6,5,0,11),iters_remain_h1=c(4,0,0,4),iters_stopped_h0=c(4,1,5,10),iters_stopped_h1=c(6,4,0,10),alpha_local_p=structure(c(0.00417643229166667,0.00417643229166667,0.00417643229166667,0.012529296875),class=c("numeric","possa_p")),futil_local_p=structure(c(0.5,0.5,NA,NA),class=c("numeric","possa_p","possa_futility")),ratio_sign_p_h0=c(0,0,0,0),ratio_futil_p_h0=c(0.3,0.2,0,0.5),ratio_sign_p_h1=c(0.6,0.4,0,1),ratio_futil_p_h1=c(0,0,0,0),ratio_stopped_h0=c(0.4,0.1,0.5,1),ratio_stopped_h1=c(0.6,0.4,0,1),ratio_combined_sign_h0=c(0,0,0,0),ratio_combined_sign_h1=c(0.6,0.4,0,1),ratio_combined_fut_h0=c(0.4,0.1,0.5,1),ratio_combined_fut_h1=c(0,0,0,0),ratio_remain_h0=c(0.6,0.5,0,1.1),ratio_remain_h1=c(0.4,0,0,0.4),n_avg_prop_0=c(13.2,6.6,49.5,69.3),n_avg_prop_1=c(19.8,26.4,0,46.2)),row.names=c(NA,-4L),class=c("possa_pow_df","data.frame")))

    expect_equal(pow_paired_futs$pow, structure(list(look=c("1","2","3","totals"),n=c(33,66,99,198),n_rate=c(0.333333333333333,0.666666666666667,1,2),iters_sign_h0=c(0,0,0,0),iters_sign_h1=c(0,0,10,10),iters_fut_h0=c(4,4,2,10),iters_fut_h1=c(0,0,10,10),iters_sign_p_h0=c(0,0,0,0),iters_sign_p_h1=c(0,0,10,10),iters_futil_p_h0=c(0,0,10,10),iters_futil_p_h1=c(0,0,10,10),iters_remain_h0=c(6,2,0,8),iters_remain_h1=c(10,10,0,20),iters_stopped_h0=c(4,4,2,10),iters_stopped_h1=c(0,0,10,10),alpha_local_p=structure(c(0,0,0.05,0.05),class=c("numeric","possa_p")),futil_local_p=structure(c(0.5,0.2,NA,NA),class=c("numeric","possa_p","possa_futility")),ratio_sign_p_h0=c(0,0,0,0),ratio_futil_p_h0=c(0,0,1,1),ratio_sign_p_h1=c(0,0,1,1),ratio_futil_p_h1=c(0,0,1,1),ratio_stopped_h0=c(0.4,0.4,0.2,1),ratio_stopped_h1=c(0,0,1,1),ratio_combined_sign_h0=c(0,0,0,0),ratio_combined_sign_h1=c(0,0,1,1),ratio_combined_fut_h0=c(0.4,0.4,0.2,1),ratio_combined_fut_h1=c(0,0,1,1),ratio_remain_h0=c(0.6,0.2,0,0.8),ratio_remain_h1=c(1,1,0,2),n_avg_prop_0=c(13.2,26.4,19.8,59.4),n_avg_prop_1=c(0,0,99,99)),row.names=c(NA,-4L),class=c("possa_pow_df","data.frame")))

    expect_equal(pow_unpaired_futs$pow, structure(list(look=c("1","2","3","totals"),n=c(33,66,99,198),n_rate=c(0.333333333333333,0.666666666666667,1,2),iters_sign_h0=c(0,0,0,0),iters_sign_h1=c(0,0,10,10),iters_fut_h0=c(7,1,2,10),iters_fut_h1=c(0,0,10,10),iters_sign_p_h0=c(0,0,0,0),iters_sign_p_h1=c(0,0,10,10),iters_futil_p_h0=c(0,0,10,10),iters_futil_p_h1=c(0,0,10,10),iters_remain_h0=c(3,2,0,5),iters_remain_h1=c(10,10,0,20),iters_stopped_h0=c(7,1,2,10),iters_stopped_h1=c(0,0,10,10),alpha_local_p=structure(c(0,0,0.05,0.05),class=c("numeric","possa_p")),futil_local_p=structure(c(0.5,0.5,NA,NA),class=c("numeric","possa_p","possa_futility")),ratio_sign_p_h0=c(0,0,0,0),ratio_futil_p_h0=c(0,0,1,1),ratio_sign_p_h1=c(0,0,1,1),ratio_futil_p_h1=c(0,0,1,1),ratio_stopped_h0=c(0.7,0.1,0.2,1),ratio_stopped_h1=c(0,0,1,1),ratio_combined_sign_h0=c(0,0,0,0),ratio_combined_sign_h1=c(0,0,1,1),ratio_combined_fut_h0=c(0.7,0.1,0.2,1),ratio_combined_fut_h1=c(0,0,1,1),ratio_remain_h0=c(0.3,0.2,0,0.5),ratio_remain_h1=c(1,1,0,2),n_avg_prop_0=c(23.1,6.6,19.8,49.5),n_avg_prop_1=c(0,0,99,99)),row.names=c(NA,-4L),class=c("possa_pow_df","data.frame")))

    expect_equal(pow_paired_7$pow, structure(list(look=c("1","2","3","4","5","6","7","totals"),n=c(33,44,55,66,77,88,99,462),n_rate=c(0.333333333333333,0.444444444444444,0.555555555555556,0.666666666666667,0.777777777777778,0.888888888888889,1,4.66666666666667),iters_sign_h0=c(0,0,0,0,0,0,0,0),iters_sign_h1=c(10,0,0,0,0,0,0,10),iters_sign_p_h0=c(0,0,0,0,0,0,0,0),iters_sign_p_h1=c(10,0,0,0,0,0,0,10),iters_remain_h0=c(10,10,10,10,10,10,0,60),iters_remain_h1=c(0,0,0,0,0,0,0,0),iters_stopped_h0=c(0,0,0,0,0,0,10,10),iters_stopped_h1=c(10,0,0,0,0,0,0,10),alpha_local_p=structure(c(0.0548381696428571,0.0548381696428571,0.0548381696428571,0.0548381696428571,0.0548381696428571,0.0548381696428571,0.0548381696428571,0.3838671875),class=c("numeric","possa_p")),ratio_sign_p_h0=c(0,0,0,0,0,0,0,0),ratio_sign_p_h1=c(1,0,0,0,0,0,0,1),ratio_stopped_h0=c(0,0,0,0,0,0,1,1),ratio_stopped_h1=c(1,0,0,0,0,0,0,1),ratio_combined_sign_h0=c(0,0,0,0,0,0,0,0),ratio_combined_sign_h1=c(1,0,0,0,0,0,0,1),ratio_remain_h0=c(1,1,1,1,1,1,0,6),ratio_remain_h1=c(0,0,0,0,0,0,0,0),n_avg_prop_0=c(0,0,0,0,0,0,99,99),n_avg_prop_1=c(33,0,0,0,0,0,0,33)),row.names=c(NA,-8L),class=c("possa_pow_df","data.frame")))

})

#
# cat('DF: ', gsub(" ", "", paste(deparse(dput(
#     original
# )), collapse = ''), fixed = TRUE))
